dnl #------------------------------------------------------------------------
define(DWM_SET_PKGVARS,[
  AC_MSG_CHECKING([package variables])
  PKG_SUBDIR=[staging]
  TAGFULL=`./getvers.sh`
  if test "$TAGFULL" = "" ; then
    TAGFULL=$2
  fi
  TAGNAME=`echo $TAGFULL | cut -d'-' -f1`
  TAGVERSION=`echo $TAGFULL | cut -d'-' -f2-`
  TARDIR_RELATIVE=${PKG_SUBDIR}
  TAR_UPDATE_FLAGS="-Ppuvf"
  case $host_os in
    darwin*)
      OSNAME="darwin"
      OSVERSION=`uname -r`
      OSARCH=`uname -m`
      TAR="/usr/bin/tar"
      ;;
    freebsd*)
      OSNAME="freebsd"
      OSVERSION=`uname -r | cut -d- -f1`
      OSARCH=`uname -m`
      case $OSARCH in
	i[[3456]]86)
	  OSARCH=intel
	  ;;
	amd64)
	  OSARCH=intel
	  ;;
	*)
	  ;;
      esac
      TAR="/usr/bin/tar"
      ;;
    linux*)
      OSNAME="linux"
      OSVERSION=`uname -r | cut -d'-' -f1`
      OSARCH=`uname -m`
      case $OSARCH in
	i[[3456]]86)
	  OSARCH=intel
	  ;;
	x86_64)
	  OSARCH=intel
	  ;;
	*)
	  ;;
      esac
      TAR="/bin/tar"
      ;;
    solaris*)
      OSNAME="solaris"
      OSVERSION=`uname -r`
      OSARCH=`uname -p`
      case $OSVERSION in
	5.*)
	  OSVERSION=`echo $OSVERSION | sed 's/5/2/1'`
	  ;;
	*)
	  ;;
      esac
      TAR="/usr/bin/tar"
      TAR_UPDATE_FLAGS="-puvf"
      ;;
    *)
      ;;
  esac
  TARDIR=`pwd`/`dirname $[0]`/${TARDIR_RELATIVE}
  AC_SUBST(OSNAME)
  AC_SUBST(OSVERSION)
  AC_SUBST(OSARCH)
  AC_SUBST(TAGFULL)
  AC_SUBST(TAGNAME)
  AC_SUBST(TAGVERSION)
  AC_SUBST(PKG_SUBDIR)
  AC_SUBST(TAR)
  AC_SUBST(TARDIR)
  AC_SUBST(TARDIR_RELATIVE)
  AC_SUBST(TAR_UPDATE_FLAGS)
  AC_MSG_RESULT([
    OSNAME=\"${OSNAME}\"
    OSVERSION=\"${OSVERSION}\"
    OSARCH=\"${OSARCH}\"
    TAGFULL=\"${TAGFULL}\"
    TAGNAME=\"${TAGNAME}\"
    TAGVERSION=\"${TAGVERSION}\"
    PKG_SUBDIR=\"${PKG_SUBDIR}\"
    TAR=\"${TAR}\"
    TARDIR=\"${TARDIR}\"
    TARDIR_RELATIVE=\"${TARDIR_RELATIVE}\"
    TAR_UPDATE_FLAGS=\"${TAR_UPDATE_FLAGS}\"])
])

dnl #------------------------------------------------------------------------
define(MCLOC_CHECK_LIB_TRIVIAL_CPLUSPLUS,[
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  prev_LDFLAGS="$LDFLAGS"
  CXXFLAGS="$CXXFLAGS -std=c++17"
  LDFLAGS="${LDFLAGS} [$1]"
  AC_MSG_CHECKING([for [$1]])
  AC_TRY_COMPILE([$2],[$3],
                 [AC_MSG_RESULT(yes)
                  AC_SUBST(LDFLAGS)],
                 [AC_MSG_RESULT(no)
                  LDFLAGS="$prev_LDFLAGS"])
  CXXFLAGS="$prev_CPPFLAGS"
  AC_LANG_POP()
])

dnl #------------------------------------------------------------------------
define(MCLOC_NEED_LIBSTDCPPFS,[
  AC_MSG_CHECKING(if we need libstdc++fs)
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  prev_LIBS="$LIBS"
  CXXFLAGS="$CXXFLAGS -std=c++17"
  AC_TRY_LINK([#include <filesystem>],
              [std::filesystem::path  fspath(".");
	       std::filesystem::file_status  st =
	       std::filesystem::status(fspath);],
  	      [AC_MSG_RESULT(no)],
	      [LIBS="${LIBS} -lstdc++fs"
	       AC_TRY_LINK([#include <filesystem>],
		           [std::filesystem::path  fspath(".");
		            std::filesystem::file_status  st =
		            std::filesystem::status(fspath);],
                 [AC_MSG_RESULT(yes)
		  AC_SUBST(LIBS)],
		 [LIBS="$prev_LIBS"])])
  AC_LANG_POP()		  
])
