//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMclocScanWorker.cc 10264 2020-01-14 05:20:18Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2019
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMclocScanWorker.cc
//!  \brief NOT Dwm::Mcloc::ScanWorker class implementation
//---------------------------------------------------------------------------

#include <unordered_map>

#include "DwmMclocCodeUtils.hh"
#include "DwmMclocLanguage.hh"
#include "DwmMclocScanWorker.hh"

static const std::string svnid("@(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.3/DwmMclocScanWorker.cc 10264 $");

using namespace std;

namespace Dwm {

  namespace Mcloc {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ScanWorker::ScanWorker(ScanWorker::Queue_t & queue)
        : _queue(queue), _thread()
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ScanWorker::Start()
    {
      _thread = std::thread(&ScanWorker::Run, this);
      return true;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void ScanWorker::Finish()
    {
      if (_thread.joinable()) {
        _thread.join();
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void ScanWorker::Run()
    {
      std::pair<std::filesystem::path,SourceFileInfo *>  entry;
      while (_queue.PopBack(entry)) {
        const Language  *language =
          CodeUtils::PathToLanguage(entry.first);
        if (nullptr != language) {
          language->Scanner()->Scan(entry.first, *(entry.second));
        }
      }
      return;
    }
    
  }  // namespace Mcloc

}  // namespace Dwm
