%{
  //===========================================================================
  // @(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.3/DwmMclocFlexFileScanner.lex 10309 $
  // @(#) $Id: DwmMclocFlexFileScanner.lex 10309 2020-01-27 03:33:03Z dwm $
  //===========================================================================
  //  Copyright (c) Daniel W. McRobb 2020
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //===========================================================================
  
  //---------------------------------------------------------------------------
  //!  \file DwmMclocFlexFileScanner.lex
  //!  \author Daniel W. McRobb
  //!  \brief NOT YET DOCUMENTED
  //---------------------------------------------------------------------------
  
  #include "DwmMclocFlexFileScanner.hh"

  static const std::string svnid("@(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.3/DwmMclocFlexFileScanner.lex 10309 $");
%}

 //  flex options
%option prefix="flex_"
%option 8bit full reentrant stack noyywrap
%option outfile="DwmMclocFlexFileScanner.cc"
%option extra-type="Dwm::Mcloc::SourceFileInfo *"

 //  patterns
m_blankLine         ^[ \t]*\n
m_cppCommLine       ^[ \t]*[/][/].*\n
m_cCommLine         ^[ \t]*[/][*].*[*][/][ \t]*\n
m_ppLine            ^[ \t]*[#].*\n
m_rulesCppCommLine  ^[ \t]+[/][/].*\n
m_rulesCCommLine    ^[ \t]+[/][*].*[*][/][ \t]*\n

 //  states
%x x_block
%x x_rules
%x x_cpp
%X x_comment
%x x_quote

%%

 // Note that the INITIAL state is used in the 'definitions' section, which
 // is syntactically different than the 'rules' and the 'user code' sections
 // of a flex input file.
<INITIAL>^[%][{][ \t]*\n        { yyextra->Counter().IncrementCodeLines();
                                  yy_push_state(x_block, yyscanner); }
<INITIAL>^[%][{]                { yy_push_state(x_block, yyscanner); }
<INITIAL>>^[%][%][ \t]*\n       { yyextra->Counter().IncrementCodeLines();
                                  yy_push_state(x_rules, yyscanner); }
<INITIAL>^[%][%]                { yy_push_state(x_rules, yyscanner); }
<INITIAL>{m_blankLine}
<INITIAL>[^%{\n]+
<INITIAL>.
<INITIAL>\n                     { yyextra->Counter().IncrementCodeLines(); }

<x_block,x_cpp>{m_cppCommLine}  { yyextra->Counter().IncrementCommentLines(); }
<x_block,x_cpp>{m_cCommLine}    { yyextra->Counter().IncrementCommentLines(); }
<x_block,x_cpp>[/][*]           { yy_push_state(x_comment, yyscanner); }
<x_block,x_cpp>\\\"
<x_block,x_cpp>\"               { yy_push_state(x_quote, yyscanner); }
<x_block,x_cpp>{m_blankLine}
<x_block,x_cpp>{m_ppLine}       { yyextra->Counter().IncrementCodeLines(); }

<x_block>[^%}"/*#\n]+
<x_block>^[%][}]                { yy_pop_state(yyscanner); }
<x_cpp>[^"/*#\n]+

<x_block,x_cpp>.
<x_block,x_cpp>\n               { yyextra->Counter().IncrementCodeLines(); }

<x_rules>{m_rulesCppCommLine}   { yyextra->Counter().IncrementCommentLines(); }
<x_rules>{m_rulesCCommLine}     { yyextra->Counter().IncrementCommentLines(); }
<x_rules>[^%/\n]+

<x_rules>^[%][%][ \t]*\n        { yyextra->Counter().IncrementCodeLines();
                                  BEGIN(x_cpp); }
<x_rules>^[%][%]                { BEGIN(x_cpp); }
<x_rules>.
<x_rules>\n                     { yyextra->Counter().IncrementCodeLines(); }

<x_comment>\*\/[ \t]*\n         { yyextra->Counter().IncrementCommentLines();
                                  yy_pop_state(yyscanner); }
<x_comment>\*\/                 { yy_pop_state(yyscanner); }
<x_comment>{m_blankLine}
<x_comment>[^ /*\n]+
<x_comment>.
<x_comment>\n                   { yyextra->Counter().IncrementCommentLines(); }

<x_quote>\\\"
<x_quote>[^\\"\n]+
<x_quote>\"                     { yy_pop_state(yyscanner); }
<x_quote>.
<x_quote>\n                     { yyextra->Counter().IncrementCodeLines(); }

%%

namespace Dwm {

  namespace Mcloc {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void FlexFileScanner::Scan(const std::filesystem::path & path,
                               SourceFileInfo & sfi) const
    {
      sfi.Counter().Reset();
      yyscan_t  scanner;
      flex_lex_init_extra(&sfi, &scanner);
      // flex_set_debug(1, scanner);
      FILE  *inFile = fopen(path.string().c_str(), "r");
      if (inFile) {
        flex_set_in(inFile, scanner);
        flex_lex(scanner);
        fclose(inFile);
      }
      flex_lex_destroy(scanner);
      return;
    }

  }  // namespace Mcloc

}  // namespace Dwm
