%{
  //=========================================================================
  // @(#) $Name:$
  // @(#) $Id: DwmMclocCppFileScanner.lex 10309 2020-01-27 03:33:03Z dwm $
  //=========================================================================
  //  Copyright (c) Daniel W. McRobb 2019, 2020
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //=========================================================================
  
  //-------------------------------------------------------------------------
  //!  \file DwmMclocCppFileScanner.lex
  //!  \brief Dwm::Mcloc::CppFileScanner implementation and lexical scanner
  //-------------------------------------------------------------------------

  #include "DwmMclocCppFileScanner.hh"

  static const std::string svnid("@(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.1/DwmMclocCppFileScanner.lex 10309 $");
%}

 //  flex options
%option prefix="cpp_"
%option 8bit full reentrant noyywrap
%option outfile="DwmMclocCppFileScanner.cc"
%option extra-type="Dwm::Mcloc::SourceFileInfo *"

 //  patterns
m_bisonGenerated ^[/][/*]\ A\ Bison\ parser,\ made\ by\ GNU\ Bison\ .+\n
m_blankLine      ^[ \t]*\n
m_flexGenerated  ^[#]define\ FLEX_SCANNER[ \t]*\n
m_cppCommentLine ^[ \t]*[/][/].*\n
m_cCommentLine   ^[ \t]*[/][*].*[*][/][ \t]*[\n]
m_ppLine         ^[#]line\ [0-9]+
   
 //  states
%x x_inComment
%x x_ppFileReference
%x x_quote
   
%%

<INITIAL>{m_bisonGenerated}     { yyextra->Counter().IncrementCommentLines();
                                  yyextra->IsGenerated(true); }
<INITIAL>{m_cppCommentLine}     { yyextra->Counter().IncrementCommentLines(); }
<INITIAL>{m_flexGenerated}      { yyextra->Counter().IncrementCommentLines();
                                  yyextra->IsGenerated(true); }
<INITIAL>{m_ppLine}[ \t]+\"     { BEGIN(x_ppFileReference); }
<INITIAL>{m_cCommentLine}       { yyextra->Counter().IncrementCommentLines(); }
<INITIAL>[/][*]                 { BEGIN(x_inComment); }
<INITIAL>\"                     { BEGIN(x_quote); }
<INITIAL>{m_blankLine}
<INITIAL>^[ \t]*[#]include.+\n   { yyextra->Counter().IncrementCodeLines(); }
<INITIAL>^[ \t]*[#]define\ [^F].+\n    { yyextra->Counter().IncrementCodeLines(); }
<INITIAL>^[ \t]*[#]if.+\n    { yyextra->Counter().IncrementCodeLines(); }
<INITIAL>[^"/*#\n]+
<INITIAL>.
<INITIAL>[\n]                   { yyextra->Counter().IncrementCodeLines(); }

<x_ppFileReference>[^"]+        { if (yyextra->GeneratedBy().empty()) {
                                    std::filesystem::path  refPath(yytext);
                                    std::filesystem::path  refFile = 
                                      refPath.filename();
                                    yyextra->GeneratedBy(refFile);
                                  }
                                }
<x_ppFileReference>["]          { BEGIN(INITIAL); }

<x_inComment>[^*\n]*
<x_inComment>[^*\n]*\n          { yyextra->Counter().IncrementCommentLines(); }
<x_inComment>"*"+[^*/\n]*
<x_inComment>"*"+[^*/\n]*\n     { yyextra->Counter().IncrementCommentLines(); }
<x_inComment>\*\/[ \t]*\n       { yyextra->Counter().IncrementCommentLines();
                                  BEGIN(INITIAL); }
<x_inComment>"*"+"/"            { BEGIN(INITIAL); }

<x_quote>[\\]["]
<x_quote>\"                     { BEGIN(INITIAL); }                      
<x_quote>.
<x_quote>[\n]                   { yyextra->Counter().IncrementCodeLines(); }

<<EOF>>                         { return 0; }
  
%%

namespace Dwm {

  namespace Mcloc {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void CppFileScanner::Scan(const std::filesystem::path & path,
                              SourceFileInfo & sfi) const
    {
      sfi.Counter().Reset();
      yyscan_t  scanner;
      cpp_lex_init_extra(&sfi, &scanner);
      // cpp_set_debug(1, scanner);
      FILE  *inFile = fopen(path.string().c_str(), "r");
      if (inFile) {
        cpp_set_in(inFile, scanner);
        cpp_lex(scanner);
        fclose(inFile);
      }
      cpp_lex_destroy(scanner);
      return;
    }

  }  // namespace Mcloc

}  // namespace Dwm
