%{
  //===========================================================================
  // @(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.0/DwmMclocEnvToArgsParse.y 10340 $
  // @(#) $Id: DwmMclocEnvToArgsParse.y 10340 2020-02-06 13:37:33Z dwm $
  //===========================================================================
  //  Copyright (c) Daniel W. McRobb 2020
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //===========================================================================
  
  //---------------------------------------------------------------------------
  //!  \file DwmMclocEnvToArgsParse.y
  //!  \author Daniel W. McRobb
  //!  \brief Dwm::Mcloc::EnvToArgs environment variable parser
  //---------------------------------------------------------------------------

  extern "C" {
    extern void mclocenverror(const char *arg, ...);
  }

  #include "DwmMclocEnvToArgs.hh"

  extern Dwm::Mcloc::EnvToArgs  *g_mclocEnvArgs;

  static const std::string svntag("@(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.0/DwmMclocEnvToArgsParse.y 10340 $");
%}

%define api.prefix {mclocenv}

%union {
    const std::string                     *stringVal;
}

%code provides
{
  // Tell Flex the expected prototype of yylex.
  #define YY_DECL                             \
    int mclocenvlex ()

  // Declare the scanner.                                                      
  YY_DECL;
}

%token <stringVal>  STRING

%%

Args: Arg
{}
| Args ':' Arg
{};

Arg: ArgNoValue
{}
| ArgWithValue
{};

ArgNoValue: STRING
{
  g_mclocEnvArgs->Add((*$1)[0]);
  delete $1;
};

ArgWithValue: STRING '=' STRING
{
  g_mclocEnvArgs->Add((*$1)[0], *$3);
  delete $1;
  delete $3;
};

%%

