%{
  //===========================================================================
  // @(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.0/DwmMclocEnvToArgsLex.lex 10341 $
  // @(#) $Id: DwmMclocEnvToArgsLex.lex 10341 2020-02-06 13:39:27Z dwm $
  //===========================================================================
  //  Copyright (c) Daniel W. McRobb 2020
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //===========================================================================
  
  //---------------------------------------------------------------------------
  //!  \file DwmMclocEnvToArgsLex.lex
  //!  \author Daniel W. McRobb
  //!  \brief NOT YET DOCUMENTED
  //---------------------------------------------------------------------------

  #include <string>

  #include "DwmMclocEnvToArgs.hh"
  #include "DwmMclocEnvToArgsParse.hh"

  static const std::string svntag("@(#) $DwmPath: dwm/mcplex/mcloc/tags/mcloc-1.0.0/DwmMclocEnvToArgsLex.lex 10341 $");
  
  extern int mclocenvparse();

    extern "C" {
    #include <stdarg.h>

    void mclocenverror(const char *arg, ...)
    {
      va_list  ap;
      va_start(ap, arg);
      vfprintf(stderr, arg, ap);
      fprintf(stderr, ": '%s' at line %d\n",
              yytext, yylineno);
      return;
    }
  }

  Dwm::Mcloc::EnvToArgs  *g_mclocEnvArgs = nullptr;

%}

%option noyywrap yylineno
%option prefix="mclocenv"

%%

<INITIAL>[:]           { return ':'; }
<INITIAL>[=]           { return '='; }
<INITIAL>[^:=]+        { mclocenvlval.stringVal = new std::string(yytext);
                         return STRING; }

%%

namespace Dwm {

  namespace Mcloc {
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    EnvToArgs::EnvToArgs(const std::string & envVarName)
    {
      g_mclocEnvArgs = this;
      
      const char  *envPtr = getenv(envVarName.c_str());
      if (nullptr != envPtr) {
        YY_BUFFER_STATE  bufferState = yy_scan_string(envPtr);
        mclocenvparse();
        yy_delete_buffer(bufferState);
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void EnvToArgs::Add(char c)
    {
      _args[c] = true;
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void EnvToArgs::Add(char c, const std::string & value)
    {
      _args[c] = value;
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool EnvToArgs::Exists(char c) const
    {
      return (_args.find(c) != _args.end());
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string EnvToArgs::Value(char c) const
    {
      std::string  rc;
      auto  it = _args.find(c);
      if (it != _args.end()) {
        if (it->second.index() == 1) {
          rc = std::get<std::string>(it->second);
        }
      }
      return rc;
    }
    


  }  // namespace Mcloc

}  // namespace Dwm
