//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockLogEntryTrackers.cc 9204 2017-04-21 13:44:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockLogEntryTrackers.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcBlockLogEntryTrackers.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.3.6/apps/mcblockd/DwmMcBlockLogEntryTrackers.cc 9204 $");

using namespace std;

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    LogEntryTracker::LogEntryTracker(const string & country)
        : _country(country), _logTimes()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LogEntryTracker::Add(const TimeValue64 & logTime)
    {
      _logTimes.push_back(logTime);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & LogEntryTracker::Country() const
    {
      return _country;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & LogEntryTracker::Country(const string & country)
    {
      _country = country;
      return _country;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool
    LogEntryTracker::HitThreshold(const AddRulesForTable & addRules) const
    {
      bool      rc = false;
      uint32_t  currentHits = CurrentHitLevel(addRules);
      AddRule   addRule;
      addRules.FindRuleForCountry(_country, addRule);
      if (currentHits >= addRule.LogThresh()) {
        rc = true;
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t
    LogEntryTracker::CurrentHitLevel(const AddRulesForTable & addRules) const
    {
      uint32_t  rc = 0;
      AddRule   addRule;
      addRules.FindRuleForCountry(_country, addRule);
      TimeValue64  periodStart(true);
      TimeValue64  period(addRule.LogDays() * 24 * 60 * 60, 0);
      periodStart -= period;
      auto  it = _logTimes.begin();
      while ((it = find_if(it, _logTimes.end(),
                           [&] (const TimeValue64 & lt)
                           { return lt >= periodStart; }))
             != _logTimes.end()) {
            ++rc;
            ++it;
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LogEntryTracker::ClearOld(const AddRulesForTable & addRules)
    {
      AddRule   addRule;
      if (addRules.FindRuleForCountry(_country, addRule)) {
        TimeValue64  periodStart(true);
        TimeValue64  period(addRule.LogDays() * 24 * 60 * 60, 0);
        periodStart -= period;
        auto it = _logTimes.begin();
        while ((it = find_if(it, _logTimes.end(),
                             [&] (const TimeValue64 & lt)
                             { return (lt < periodStart); }))
               != _logTimes.end()) {
          it = _logTimes.erase(it);
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool LogEntryTracker::IsEmpty() const
    {
      return _logTimes.empty();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void TableLogEntryTracker::Add(const Ipv4Prefix & prefix,
                                   const string & country,
                                   const TimeValue64 & logTime)
    {
      lock_guard<mutex>  lock(_mtx);
      _trackers[prefix].Country(country);
      _trackers[prefix].Add(logTime);
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool
    TableLogEntryTracker::HitThreshold(const Ipv4Prefix & prefix,
                                       const AddRulesForTable & addRules) const
    {
      lock_guard<mutex>  lock(_mtx);
      bool  rc = false;
      auto  it = _trackers.find(prefix);
      if (it != _trackers.end()) {
        if (it->second.HitThreshold(addRules)) {
          rc = true;
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t TableLogEntryTracker::
    CurrentHitLevel(const Ipv4Prefix & prefix,
                    const AddRulesForTable & addRules) const
    {
      lock_guard<mutex>  lock(_mtx);
      uint32_t  rc = 0;
      auto  it = _trackers.find(prefix);
      if (it != _trackers.end()) {
        rc = it->second.CurrentHitLevel(addRules);
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void TableLogEntryTracker::ClearOld(const AddRulesForTable & addRules)
    {
      lock_guard<mutex>  lock(_mtx);
      auto  it = _trackers.begin();
      while (it != _trackers.end()) {
        it->second.ClearOld(addRules);
        if (it->second.IsEmpty()) {
          it = _trackers.erase(it);
        }
        else {
          ++it;
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void TableLogEntryTracker::Remove(const Ipv4Prefix & prefix)
    {
      lock_guard<mutex>  lock(_mtx);
      auto  it = _trackers.find(prefix);
      if (it != _trackers.end()) {
        _trackers.erase(it);
      }
    }
    



  }  // namespace McBlock

}  // namespace Dwm
