//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockRequestMessage.cc 12091 2022-11-29 05:05:27Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockRequestMessage.cc
//!  \brief Dwm::McBlock::RequestMessage class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmCredencePeer.hh"
#include "DwmMcBlockRequestMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.3.3/classes/src/DwmMcBlockRequestMessage.cc 12091 $");

using namespace std;

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ActivateReq::ActivateReq(const string & table,
                             const vector<Ipv4Prefix> & prefixes)
    {
      (*this)["type"] = "activate";
      (*this)["table"] = table;
      for (uint32_t i = 0; i < prefixes.size(); ++i) {
        (*this)["prefixes"][i] = prefixes[i].ToShortString();
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DeactivateReq::DeactivateReq(const string & table,
                                 const vector<Ipv4Prefix> & prefixes)
    {
      (*this)["type"] = "deactivate";
      (*this)["table"] = table;
      for (uint32_t i = 0; i < prefixes.size(); ++i) {
        (*this)["prefixes"][i] = prefixes[i].ToShortString();
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SearchReq::SearchReq(const Ipv4Address & addr)
    {
      (*this)["type"] = "search";
      (*this)["ipv4addr"] = (string)addr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GetActiveReq::GetActiveReq(const std::string & table)
    {
      (*this)["type"] = "getActive";
      (*this)["table"] = table;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GetAddRulesReq::GetAddRulesReq(const std::string & table)
    {
      (*this)["type"] = "getAddRules";
      (*this)["table"] = table;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    LogHitReq::LogHitReq(const std::string & table, const Ipv4Address & addr,
                         const TimeValue64 & logTime)
    {
      (*this)["type"] = "logHit";
      (*this)["table"] = table;
      (*this)["ipv4addr"] = (string)addr;
      (*this)["logTime"] = logTime.Secs();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GetReq::GetReq(const std::string & table, const Ipv4Address & addr)
    {
      (*this)["type"] = "get";
      (*this)["table"] = table;
      (*this)["ipv4addr"] = (string)addr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GetMatchesReq::GetMatchesReq(const string & table,
                                 const Ipv4Prefix & prefix)
    {
      (*this)["type"] = "getMatches";
      (*this)["table"] = table;
      (*this)["prefix"] = prefix.ToShortString();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage()
        : _value()
    {
      _value["type"] = "none";
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage(const nlohmann::json & req)
        : _value(req)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage(const nlohmann::json && req)
        : _value(std::move(req))
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RequestMessage::Read(Credence::Peer & peer)
    {
      bool  rc = false;
      _value.clear();
      std::string  s;
      if (peer.Receive(s)) {
        _value = nlohmann::json::parse(s, nullptr, false);
        rc = (! _value.is_discarded());
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RequestMessage::Write(Credence::Peer & peer) const
    {
      bool  rc = false;
      std::string  s = _value.dump();
      rc = peer.Send(s);
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & RequestMessage::Json() const
    {
      return _value;
    }
    
    
  }  // namespace McBlock

}  // namespace Dwm
