//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockLogEntryTrackers.hh 9204 2017-04-21 13:44:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockLogEntryTrackers.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCBLOCKLOGENTRYTRACKERS_HH_
#define _DWMMCBLOCKLOGENTRYTRACKERS_HH_

#include <deque>
#include <map>
#include <mutex>
#include <string>

#include "DwmIpv4Prefix.hh"
#include "DwmTimeValue64.hh"
#include "DwmMcBlockAddRules.hh"

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class LogEntryTracker
    {
    public:
      LogEntryTracker() = default;
      LogEntryTracker(const std::string & country);
      void Add(const TimeValue64 & logTime);
      const std::string & Country() const;
      const std::string & Country(const std::string & country);
      bool HitThreshold(const AddRulesForTable & addRules) const;
      uint32_t CurrentHitLevel(const AddRulesForTable & addRules) const;
      void ClearOld(const AddRulesForTable & addRules);
      bool IsEmpty() const;
      
      // ...
    private:
      std::string              _country;
      std::deque<TimeValue64>  _logTimes;
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class TableLogEntryTracker
    {
    public:
      TableLogEntryTracker() = default;
      void Add(const Ipv4Prefix & prefix, const std::string & country,
               const TimeValue64 &	logTime);
      bool HitThreshold(const Ipv4Prefix & prefix,
                        const AddRulesForTable & addRules) const;
      uint32_t CurrentHitLevel(const Ipv4Prefix & prefix,
                               const AddRulesForTable & addRules) const;
      void ClearOld(const AddRulesForTable & addRules);
      void Remove(const Ipv4Prefix & prefix);
      
    private:
      std::map<Ipv4Prefix, LogEntryTracker>	 _trackers;
      mutable std::mutex                     _mtx;
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    typedef std::map<std::string, TableLogEntryTracker>	 LogEntryTrackers;

  }  // namespace McBlock

}  // namespace Dwm

#endif  // _DWMMCBLOCKLOGENTRYTRACKERS_HH_
