//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockResponseMessage.cc 9242 2017-04-25 17:27:24Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockResponseMessage.cc
//!  \brief Dwm::McBlock::ResponseMassage class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmAuthSymCryptoMessage.hh"
#include "DwmMcBlockResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.1.1/classes/src/DwmMcBlockResponseMessage.cc 9242 $");

using namespace std;

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage()
        : _value()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(const Json::Value & value)
        : _value(value)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(const Json::Value && value)
        : _value(std::move(value))
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Json::Value & ResponseMessage::Json() const
    {
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Json::Value & ResponseMessage::Json(const Json::Value & value)
    {
      _value = value;
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Read(int fd, const string & secret)
    {
      bool  rc = false;
      _value.clear();
      _value = "";
      if (fd >= 0) {
        Auth::SymCrypto::Message  msg(secret);
        if (msg.Read(fd) > 0) {
          Json::Reader  jsonReader;
          if (jsonReader.parse(msg.Value(), _value)) {
            rc = true;
          }
          else {
            Syslog(LOG_ERR, "Failed to parse response message");
          }
        }
        else {
          Syslog(LOG_ERR, "Failed to read response message");
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Write(int fd, const string & secret) const
    {
      bool  rc = false;
      if (fd >= 0) {
        Json::FastWriter  fw;
        Auth::SymCrypto::Message  msg(secret, fw.write(_value));
        if (msg.Write(fd) == msg.StreamedLength()) {
          rc = true;
        }
        else {
          Syslog(LOG_ERR, "Failed to write response message");
        }
      }
      return rc;
    }
    
    
  }  // namespace McBlock

}  // namespace Dwm
