//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockServer.hh 9274 2017-04-26 04:52:50Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockServer.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCBLOCKSERVER_HH_
#define _DWMMCBLOCKSERVER_HH_

#include <chrono>
#include <thread>
#include <vector>

#include "DwmSocket.hh"
#include "DwmCfg2Json.hh"
#include "DwmMcBlockDb.hh"
#include "DwmMcBlockResponder.hh"
#include "DwmMcBlockServerConfig.hh"
#include "DwmMcBlockAddRules.hh"
#include "DwmMcBlockLogEntryTrackers.hh"
#include "DwmPfDevice.hh"

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Server
    {
    public:
      Server(const Cfg2Json & config);

      const ServerConfig & Config() const;
      const AddRules & GetAddRules() const;
      const Pf::Device & GetPfDevice() const;
      Socket & GetSocket();
      LogEntryTrackers & GetLogEntryTrackers();
      std::map<std::string,Db> & GetDatabases();
      
      bool Start();
      
      void Stop();

    private:
      ServerConfig              _config;
      AddRules                  _addRules;
      Pf::Device                _pfdev;
      Socket                    _socket;
      Socket                    _mcastSocket;
      bool                      _run;
      std::thread               _thread;
      std::vector<Responder *>  _responders;
      LogEntryTrackers          _logEntryTrackers;
      std::map<std::string,Db>  _databases;
      std::chrono::system_clock::time_point  _nextListSaveTime;

      void CleanupResponders();
      void StopResponders();
      void CleanupLogTrackers();
      void CleanupInactiveDbEntries();
      void Run();
      void SavePfLists() const;
    };
    
  }  // namespace McBlock

}  // namespace Dwm

#endif  // _DWMMCBLOCKSERVER_HH_
