//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockAddRules.hh 9148 2017-04-18 23:12:23Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockAddRules.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCBLOCKADDRULES_HH_
#define _DWMMCBLOCKADDRULES_HH_

#include <cstdint>
#include <map>
#include <regex>
#include <vector>

#include "DwmCfg2Json.hh"
#include "DwmMcBlockDbEntry.hh"

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  Encapsulate a rule for adding to the blocked database.
    //------------------------------------------------------------------------
    class AddRule
    {
    public:
      AddRule() = default;
      AddRule(const Cfg2Json & config, const std::string & tableName,
              const std::string & ruleName);
      void Apply(DbEntry & dbEntry, const Ipv4Prefix & pfx) const;

      const std::string & Name() const;
      const std::regex & Rgx() const;
      uint8_t WidestMask() const;
      uint32_t Days() const;
      uint32_t LogThresh() const;
      uint32_t LogDays() const;
      Json::Value Json() const;
      
      friend std::ostream & operator << (std::ostream & os,
                                         const AddRule & addRule);
      
    private:
      std::string  _name;
      std::string  _countries;
      std::regex   _rgx;
      uint8_t      _widestMask;
      uint32_t     _days;
      uint32_t     _logThresh;
      uint32_t     _logDays;
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class AddRulesForTable
    {
    public:
      AddRulesForTable() = default;
      AddRulesForTable(const AddRulesForTable &) = default;
      AddRulesForTable(const Cfg2Json & config, const std::string & name);
      bool FindRuleForCountry(const std::string & country,
                              AddRule & addRule) const;
      void Apply(DbEntry & dbEntry, const Ipv4Prefix & pfx) const;
      const std::string & Name() const;
      Json::Value Json() const;
      
      friend std::ostream & operator << (std::ostream & os,
                                         const AddRulesForTable & addRules);

    private:
      std::string           _tableName;
      std::vector<AddRule>  _addRules;
    };
    
    //------------------------------------------------------------------------
    //!  Encapsulate a vector of rules for adding to the blocked database.
    //------------------------------------------------------------------------
    class AddRules
    {
    public:
      typedef std::pair<std::string,AddRulesForTable>  value_type;
      typedef std::map<std::string,AddRulesForTable>   map_type;
      typedef typename map_type::const_iterator        iterator;
      typedef const typename map_type::const_iterator  const_iterator;
      
      AddRules(const Cfg2Json & config);
      const map_type & RulesForTables() const;
      const_iterator RulesForTable(const std::string & tableName) const;
      Json::Value Json() const;
      
      friend std::ostream & operator << (std::ostream & os,
                                         const AddRules & addRules);

    private:
      std::map<std::string,AddRulesForTable>  _addRules;
    };
    
  }  // namespace McBlock

}  // namespace Dwm

#endif  // _DWMMCBLOCKADDRULES_HH_
