.Dd April 25, 2017
.Dt mcblockd 8
.Os
.Sh NAME
.Nm mcblockd
.Nd Server to automatically block hosts and networks with pf
.Sh SYNOPSIS
.Nm
.Op Fl c Ar configuration_file
.Op Fl p Ar pid_file
.Op Fl d
.Sh DESCRIPTION
.Nm
is the server portion of a system for automatically populating pf
tables.  It is normally run on a gateway between the public Internet
and an internal network, and used to manipulate pf tables applied in
rules on the external (public) network interface.  Clients of
.Nm
include
.Xr mcblocklog 1
and
.Xr mcblockc 1 .
.Pp
The following command line options are available:
.Bl -tag -width indent
.It Fl c Ar configuration_file
Specify the configuration file.  The default is
.Pa /usr/local/etc/mcblockd.conf .  See
.Xr mcblockd.conf 5
for configuration file syntax.
.It Fl p Ar pid_file
Specify the process ID (pid) file.
.Nm
will store its PID in this file at startup and remove the file on SIGTERM.
The default is
.Pa /var/run/mcblockd.pid
.It Fl d
Run in the foreground and emit syslog messages on stderr.
.El
.Sh FILES
.Bl -tag -width indent
.It Pa /usr/local/etc/mcblockd.conf
.Nm
configuration file.  See
.Xr mcblockd.conf 5
for more information and
.Pa /usr/local/etc/mcblockd.conf.sample
for an example.
.It Pa /usr/local/etc/mcblockd/id_rsa
.Nm
private key file, created with
.Xr dwmauth 1 .  This file should be owned by root with permissions 0600.
It must contain the private part of a 2048-bit RSA key pair.
.It Pa /usr/local/etc/mcblockd/id_rsa.pub
.Nm
public key file, created with
.Xr dwmauth 1 .  This file should be owned by root with permissions 0600.
It must contain the public part of a 2048-bit RSA key pair.
.It Pa /usr/local/etc/mcblockd/authorized_keys
.Nm
authorized keys file.  This file contains a list of pulbic keys (one per
line) that are permitted access to
.Nm .
.It Pa /usr/local/etc/mcblockd/known_services
.Nm
known services file.  This file is used when authenticating
.Xr dwmrdapd 8 and should contain dwmrdapd's public key.
.El
.Sh SEE ALSO
.Xr mcblockd.conf 5 ,
.Xr mcblocklog 8 ,
.Xr mcblockc 1 ,
.Xr dwmauth 1 ,
.Xr dwmrdapd 8 ,
.Xr dwmrdapd.conf 5
