.Dd April 25, 2017
.Dt mcblockd.conf 5
.Os
.Sh NAME
.Nm mcblockd.conf
.Nd mcblockd configuration file.
.Sh SYNOPSIS
.Nm
.Sh DESCRIPTION
.Nm
is the configuration file for
.Xr mcblockd 8 .
.Sh FILE FORMAT
.Nm
contains multiple stanzas.  Each stanza contains attributes (name:value pairs)
or sub-stanzas.  Stanzas are opened with a name and \fB{\fR and closed with
a \fB}\fR.  Attribute notation is \fIname: value;\fR
.Pp
Comments start with \fB#\fR and continue to the end of the line.  Empty
lines are ignored.
.Ss "Syslog" \fRstanza
The Syslog stanza contains settings for syslog.
.Bl -tag -width "   " indent
.It \fBFacility:\fI name\fR;
The syslog facility.  This may be one of "user", "daemon", "auth",
"local0", "local1", "local2", "local3", "local4", "local5", "local6"
or "local7".
.It \fBMinimumPriority: \fIpriority\fR;
The lowest priority that will be logged.  This may be "debug",
"info", "notice", "warning", "error", "critical", "alert" or
"emergency".
.It \fBShowFileLocations: \fIboolean\fR;
If \fItrue\fR, mcblockd will show file and line number information in each
syslog message.  This is typically set to \fIfalse\fR, but may be
set to \fItrue\fR during development or debugging.
.El
.Pp
An example Syslog stanza is shown below.
.Pp
.nf
Syslog {
  Facility: local0;
  MinimumPriority: info;
  ShowFileLocations: false;
}
.fi
.Ss Server\fR stanza
The Server stanza is composed of multiple sub-stanzas.
.Bl -tag -width "   " indent
.It \fBPF\fR sub-stanza
The PF sub-stanza sets the pf (packet filter) parameters.
.Bl -tag -width "   " indent
.It \fIDevice: path;
The path to the pf device.  This is normally
.Em /dev/pf
.El
.It \fBTCP\fR sub-stanza
.Bl -tag -width "   " indent
.It \fIAddress: ipv4_address;\fR
The IPv4 address to which we'll bind.  This is normally set to the address
of a private-side interface.
.It \fIPort: port_number;\fR
The port to which we'll bind.
.El
.It \fBAuth\fR sub-stanza
.Xr mcblockd 8 used libDwmAuth for authentication of clients.  Three files
are required: a private key file, a public key file and a file containing
the public keys of clients that will be allowed to access
.Xr mcblockd 8 .
.Bl -tag -width "   " indent
.It \fIPrivKeyFile: path;\fR
The path to the file containing the private half of a 2048-bit RSA key pair
used by \fBmcblockd\fR(8) when authenticating itself to a client.  This
file, and a corresponding public key file with a \fI.pub\fR suffix, must
be created with
.Xr dwmauth 1 .
.It \fIAuthorizedKeysFile: path;\fR
The path to the file containing the public halves of 2048-bit RSA key pairs
(one per line) of clients which are allowed access to
.Xr mcblockd 8 .  These keys must have been created with
.Xr dwmauth 1 .
.El
.It \fBDwmRDAP\fR sub-stanza
.Xr mcblockd 8 uses
.Xr dwmrdapd 8 to obtain prefixes and country codes for IP addresses.
The connection to
.Xr dwmrdapd 8 must be configured properly in order for
.Xr mcblockd 8 to be used effectively.
.Bl -tag -width "   " indent
.It \fIPrivKeyFile: path;\fR
The path to a file containing the private half of a 2048-bit RSA key pair
that will be used when authenticating to
.Xr dwmrdapd 8 .  The corresponding public half of the key must reside in
a file with the same name but \fI.pub\fR appended.  Normally this file is
the same as that configured in the \fBPrivKeyFile\fR attribute of the
\fBAuth\fR sub-stanza.
.It \fIKnownServices: path;\fR
The path to a file containing \fBdwmrdapd\fR's public key.
.Xr mcblockd 8 uses this to authenticate
.Xr dwmrdapd 8 .
.It \fIServer: hostname;\fR
The host where
.Xr dwprdapd 8
is running.
.El
.It \fIDatabaseDirectory: path;\fR
The directory where
.Xr mcblockd 8 will store its databases.  This must be the same directory
where you keep your pf table files for pf rules, and is hence usually
\fIetc\fR.
.El
.Pp
An example Server stanza is shown below.
.Pp
.nf
Server {
  PF { Device: "/dev/pf"; }
  TCP { Address: 10.1.1.1; Port: 1001; }
  Auth {
    PrivKeyFile: "/usr/local/etc/mcblockd/id_rsa";
    AuthorizedKeysFile: "/usr/local/etc/mcblockd/authorized_keys";
  }
  DwmRDAP {
    PrivKeyFile: "/usr/local/etc/mcblockd/id_rsa";
    KnownServices: "/usr/local/etc/mcblockd/known_services";
    Server: "gw1.example.com";
  }
  DatabaseDirectory: "/etc";
}
.fi
.Ss AddRules
The AddRules stanza contains rules for adding to the prefix database,
on a per-table basis.  Each pf table has its own sub-stanza within the
AddRules stanza, with the sub-stanza named the same as the pf table.
Within a table sub-stanza are rule sub-stanzas containing rules that
are matched in alphabetical order when mcblockd is adding a prefix to
the database.
.Pp
The matching is done against the country code of origin of the IP address,
which is specified in a rule with a regular expression.
.Pp
Within a rule are the following attributes:
.Bl -tag -width "   " indent
.It \fBcountries: \fIregular_expression\fR;
A regular expression of country codes to match against the origin of an
IP address we'd like to add to the database for the pf table.
.It \fBwidestMask: \fInetmask_length\fR;
The maximum netmask length to apply when adding an IP to the database.
.Xr dwmrdapd 8
may return a very wide mask for a given IP address, and you may wish to
constrain the width to say a /24 instead of adding a huge swath of IP
addresses.
.It \fBdays: \fIdays\fR;
The number of days to keep the new prefix active in the database (and hence
the pf table).
.It \fBlogThresh: \fIhit_count\fR;
This is used by
.Xr mcblockd 8
when responding to a 'logHit' request (say from
.Xr mcblocklog 1
).
.Xr mcblockd 8 will not insert the prefix into the database until this
threshold is exceeded during a period specified by \fBlogDays\fR.
.It \fBlogDays: \fIdays\fR;
This is used by
.Xr mcblockd 8
when responding to a 'logHit' request (say from
.Xr mcblocklog 1
).
.Xr mcblockd 8 will not insert the prefix into the database until the
threshold (\fBlogThresh\fR) is exceeded during this period, in days.

.El
An example AddRules stanza is shown below.  We have two rulesets
(corresponding to two pf tables), ssh_losers and www_losers.
.Pp
.nf
AddRules {
  ssh_losers {
    Rule1 { countries: "CA|UM|US|VI";
            widestMask: 24;     days: 30;
            logThresh:   5;  logDays: 7;
    }
    Rule2 { countries: ".*";
            widestMask: 10;     days: 180;
            logThresh:   1;  logDays: 1;
    }
  }
  www_losers {
    Rule1 { countries: "CA|GB|MX|UM|US|VI";
            widestMask: 24;     days: 30;
    }
    Rule2 { countries: "AF|AM|AR|AZ|BA|BG|BH|BO|BR|BZ|CN|CO|CL|HK|HR|"
                       "IQ|IR|KG|KH|KR|KZ|LR|LT|LV|MD|PE|PK|PS|RO|RS|"
                       "RU|SA|SI|SK|SY|TR|UA|UZ|VN";
            widestMask: 10;     days: 90;
    }
    Rule3 { countries: ".*";
            widestMask: 10;     days: 30;
    }
  }
}
.fi
.Sh SEE ALSO
.Xr mcblocklog 8 ,
.Xr mcblockc 1 ,
.Xr dwmauth 1 ,
.Xr dwmrdapd 8 ,
.Xr dwmrdapd.conf 5
