//===========================================================================
// @(#) $Name:$
// @(#) $Id: mcblocklogparser.cc 9249 2017-04-25 18:14:50Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mcblocklogparser.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netinet/tcp.h>
  #include <arpa/inet.h>
  #include <netdb.h>
  #include <pthread_np.h>
}

#include <fstream>
#include <map>

#include "DwmIpv4Prefix.hh"
#include "DwmOptArgs.hh"
#include "DwmSocket.hh"
#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmAuthPeerAuthenticator.hh"
#include "DwmAuth.hh"
#include "DwmMcBlockLogRegexMatcher.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.1.0/apps/logparser/mcblocklogparser.cc 9249 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  OptArgs  optargs;
  optargs.AddOptArg("r:", "regexFile", true, "",
                    "file containing regular expressions");
  int  nextArg = optargs.Parse(argc, argv);

  SysLogger::Open("mcblocklogparser", LOG_PID|LOG_PERROR, "user");

  McBlock::LogRegexMatcher  matcher(optargs.Get<string>('r'));
  map<Ipv4Address,uint32_t>  matches;
  
  istream  *logis;
  ifstream  logfile;
  for (int arg = nextArg; arg < argc; ++arg) {
    if (string(argv[arg]) == "-") {
      logis = &cin;
    }
    else {
      logfile.open(argv[arg]);
      logis = &logfile;
    }
    if (*logis) {
      string  line;
      while (getline(*logis, line, '\n')) {
        pair<bool,Ipv4Address>  match = matcher.Matches(line);
        if (match.first) {
          matches[match.second]++;
        }
      }
      if (string(argv[arg]) != "-") {
        logfile.close();
      }
    }
  }
  
  if (! matches.empty()) {
    vector<pair<Ipv4Address,uint32_t>> matchVec;
    for (auto & match : matches) {
      matchVec.push_back(match);
    }
    sort(matchVec.begin(), matchVec.end(),
         [&] (const pair<Ipv4Address,uint32_t> & m1,
              const pair<Ipv4Address,uint32_t> & m2) 
         { return (m1.second > m2.second); });
    cout << setiosflags(ios::left);
    for (auto & match : matchVec) {
      cout << setw(15) << match.first << ' '
           << match.second << '\n';
    }
  }
}
