//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPRequestMessage.cc 12117 2022-12-11 04:34:00Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPRequestMessage.cc
//!  \brief Dwm::RDAP::RequestMessage class implementation
//---------------------------------------------------------------------------

#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmRDAPRequestMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.3.4/src/DwmRDAPRequestMessage.cc 12117 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage()
        : _value()
    {
      _value["type"] = "none";
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage(const nlohmann::json & req)
        : _value(req)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage(const nlohmann::json && req)
        : _value(std::move(req))
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RequestMessage::RequestMessage(const vector<Ipv4Address> & addrs)
        : _value()
    {
      _value["type"] = "query";
      for (int i = 0; i < addrs.size(); ++i) {
        _value["ipv4addrs"][i] = (string)addrs[i];
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & RequestMessage::Read(std::istream & is)
    {
      _value.clear();
      if (is) {
        _value = nlohmann::json::parse(is, nullptr, false);
      }
      return is;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RequestMessage::Read(Credence::Peer & peer)
    {
      bool  rc = false;
      _value.clear();
      std::string  s;
      if (peer.Receive(s)) {
        _value = nlohmann::json::parse(s, nullptr, false);
        rc = (! _value.is_discarded());
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & RequestMessage::Write(std::ostream & os) const
    {
      if (os) {
        os << _value.dump();
      }
      return os;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RequestMessage::Write(Credence::Peer & peer) const
    {
      bool  rc = false;
      std::string  s = _value.dump();
      rc = peer.Send(s);
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & RequestMessage::Json() const
    {
      return _value;
    }
    
    
  }  // namespace RDAP

}  // namespace Dwm
