//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPResponseMessage.hh 12118 2022-12-11 04:35:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPResponseMessage.hh
//!  \brief Dwm::RDAP::ResponseMessage class declaration
//---------------------------------------------------------------------------

#ifndef _DWMRDAPRESPONSEMESSAGE_HH_
#define _DWMRDAPRESPONSEMESSAGE_HH_

#include <string>
#include <nlohmann/json.hpp>

#include "DwmStreamIOCapable.hh"
#include "DwmCredencePeer.hh"

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  Encapsulates a response message from dwmrdapd.
    //------------------------------------------------------------------------
    class ResponseMessage
      : public StreamIOCapable
    {
    public:
      ResponseMessage();
      ResponseMessage(const nlohmann::json & value);
      ResponseMessage(const nlohmann::json && value);
      const nlohmann::json & Json() const;
      const nlohmann::json & Json(const nlohmann::json & value);
      std::istream & Read(std::istream & is) override;
      std::ostream & Write(std::ostream & os) const override;
      bool Read(Credence::Peer & peer);
      bool Write(Credence::Peer & peer) const;
      
    protected:
      nlohmann::json  _value;
    };
    
  }  // namespace RDAP

}  // namespace Dwm

#endif  // _DWMRDAPRESPONSEMESSAGE_HH_
