//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPQuery.cc 12078 2022-11-26 03:33:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPQuery.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iostream>
#include <iomanip>
#include <regex>
#include <string>

#include "DwmSvnTag.hh"
#include "DwmWebUtils.hh"
#include "DwmRDAPBootstrap.hh"
#include "DwmRDAPQuery.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.3.3/src/DwmRDAPQuery.cc 12078 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Query::Query()
        : _uristr()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & Query::Uri() const
    {
      return _uristr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Response Query::Execute() const
    {
      Response  rc;
      if (! _uristr.empty()) {
        if (WebUtils::GetJson(_uristr, rc)) {
          if (! rc.is_discarded()) {
            FixIpv4Stupidity(rc["startAddress"]);
            FixIpv4Stupidity(rc["endAddress"]);
          }
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    IPv4Query::IPv4Query(const Ipv4Address & ip)
        : Query()
    {
      vector<string> servers = Bootstrap::RDAPServers(ip);
      if (! servers.empty()) {
        _uristr = servers.front();
        if (_uristr.back() != '/') {
          _uristr += '/';
        }
        _uristr += string("ip/") + (string)ip;
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    IPv4Response IPv4Query::Execute() const
    {
      return ((Query *)this)->Execute();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Query::FixIpv4Stupidity(nlohmann::json & jv)
    {
      string    rc;
      if (jv.is_string() && (! jv.get<string>().empty())) {
        regex  rgx("(0*)([0-9]+)", regex::ECMAScript|regex::optimize);
        rc = regex_replace(jv.get<string>(), rgx, "$2");
        jv = rc;
      }
      return;
    }
    
    ASQuery::ASQuery(uint32_t asnum)
    {
    }
    
    DomainQuery::DomainQuery(const std::string & domain)
    {}
    


    
  }  // namespace RDAP


}  // namespace Dwm
