//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPServerConfig.hh 9002 2017-04-10 06:39:25Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPServerConfig.hh
//!  \brief Dwm::RDAP::ServerConfig class definition
//---------------------------------------------------------------------------

#ifndef _DWMRDAPSERVERCONFIG_HH_
#define _DWMRDAPSERVERCONFIG_HH_

#include "DwmIpv4Address.hh"
#include "DwmCfg2Json.hh"

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class ServerConfig
    {
    public:
      ServerConfig(const std::string & fn = "/usr/local/etc/dwmrdapd.conf");
      bool Parse();
      Ipv4Address TCPAddress() const;
      uint16_t TCPPort() const;
      std::string RDAPIpv4BootstrapFile() const;
      std::string CountryCodesFile() const;
      std::string DatabaseFile() const;
      std::string SyslogFacility() const;
      std::string SyslogMinimumPriority() const;
      bool SyslogShowFileLocations() const;

    private:
      std::string  _filename;
      Cfg2Json     _cfg2json;

      std::string ConfString(const std::string & path,
                             const std::string & deflt) const;
      bool ConfBool(const std::string & path, bool deflt) const;
    };
    
  }  // namespace RDAP

}  // namespace Dwm

#endif  // _DWMRDAPSERVERCONFIG_HH_
