//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPQuery.cc 8946 2017-03-31 20:50:31Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPQuery.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iostream>
#include <iomanip>
#include <regex>
#include <string>

#include <Poco/Net/PrivateKeyPassphraseHandler.h>
#include <Poco/Net/HTTPClientSession.h>
#include <Poco/Net/HTTPSClientSession.h>
#include <Poco/Net/HTTPRequest.h>
#include <Poco/Net/HTTPResponse.h>
#include <Poco/Net/SSLManager.h>
#include <Poco/Net/ConsoleCertificateHandler.h>
#include <Poco/URI.h>

#include "DwmSvnTag.hh"
#include "DwmRDAPBootstrap.hh"
#include "DwmRDAPQuery.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.2.1/src/DwmRDAPQuery.cc 8946 $");

using namespace std;
using Poco::URI;
using Poco::Net::HTTPClientSession;
using Poco::Net::HTTPSClientSession;
using Poco::Net::HTTPMessage;
using Poco::Net::HTTPRequest;
using Poco::Net::HTTPResponse;
using Poco::Net::Context;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static Context::Ptr g_context =
      new Context(Context::CLIENT_USE, "", "", "",
                  Context::VERIFY_NONE, 9, false,
                  "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH");
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Query::Query()
        : _uristr()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & Query::Uri() const
    {
      return _uristr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Response Query::Execute() const
    {
      Response  rc;
      if (! _uristr.empty()) {
        Poco::URI    uri(_uristr);
        std::string  host(uri.getHost());
        std::string  path(uri.getPathAndQuery());
        HTTPClientSession    *sess;
        if (uri.getScheme() == "https") {
          sess = new HTTPSClientSession(host, uri.getPort(), g_context);
        }
        else {
          sess = new HTTPClientSession(host);
        }
        HTTPRequest  req(HTTPRequest::HTTP_GET, path, HTTPMessage::HTTP_1_1);
        try {
          ostream & os = sess->sendRequest(req);
          if (os) {
            HTTPResponse  resp;
            istream  & is = sess->receiveResponse(resp);
            Json::Reader  reader;
            if (reader.parse(is, rc)) {
              FixIpv4Stupidity(rc["startAddress"]);
              FixIpv4Stupidity(rc["endAddress"]);
            }
          }
        }
        catch (Poco::Exception &ex) {
          cerr << "Exception, URI "
               << uri.toString() << ", " << ex.className() << ", "
               << ex.name() << ", " << ex.displayText() << "\n";
        }
        delete sess;
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    IPv4Query::IPv4Query(const Ipv4Address & ip)
        : Query()
    {
      vector<string> servers = Bootstrap::RDAPServers(ip);
      if (! servers.empty()) {
        _uristr = servers.front();
        if (_uristr.back() != '/') {
          _uristr += '/';
        }
        _uristr += string("ip/") + (string)ip;
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    IPv4Response IPv4Query::Execute() const
    {
      return ((Query *)this)->Execute();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Query::FixIpv4Stupidity(Json::Value & jv)
    {
      string    rc;
      if (jv.isString() && (! jv.asString().empty())) {
        regex  rgx("(0*)([0-9]+)", regex::ECMAScript|regex::optimize);
        rc = regex_replace(jv.asString(), rgx, "$2");
        jv = Json::Value(rc);
      }
      return;
    }
    
    ASQuery::ASQuery(uint32_t asnum)
    {
    }
    
    DomainQuery::DomainQuery(const std::string & domain)
    {}
    


    
  }  // namespace RDAP


}  // namespace Dwm
