//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPBootstrap.hh 9306 2017-05-08 09:04:02Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPBootstrap.hh
//!  \brief Dwm::RDAP::Bootstrap class definition
//---------------------------------------------------------------------------

#ifndef _DWMRDAPBOOTSTRAP_HH_
#define _DWMRDAPBOOTSTRAP_HH_

#include <mutex>
#include <string>
#include <vector>

#include <json/json.h>

#include "DwmIpv4Routes.hh"

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  RDAP bootstrap class.
    //------------------------------------------------------------------------
    class Bootstrap
    {
    public:
      //----------------------------------------------------------------------
      //!  Constructor.
      //----------------------------------------------------------------------
      Bootstrap();

      //----------------------------------------------------------------------
      //!  Loads the bootstrap data from the given @c bootstrapURI.  Returns
      //!  true on success, false on failure.
      //----------------------------------------------------------------------
      static bool Load(const std::string & bootstrapURI =
                       "file:///usr/local/etc/ipv4_rdap.json");

      //----------------------------------------------------------------------
      //!  Returns true if the bootstrap is empty (not loaded or load failed).
      //----------------------------------------------------------------------
      static bool Empty();
      
      //----------------------------------------------------------------------
      //!  Returns the RDAP servers for the given IP address @c addr.
      //----------------------------------------------------------------------
      static std::vector<std::string> RDAPServers(const Ipv4Address & addr);

      static Ipv4Prefix MatchingPrefix(const Ipv4Address & addr);
      
    private:
      static Ipv4Routes<std::vector<std::string> >  _addrs2rdaps;
      static std::mutex                             _mtx;
      
      static Json::Value GetJsonResponse(const std::string & uristr);
    };
    
      
  }  // namespace RDAP

}  // namespace Dwm

#endif  // _DWMRDAPBOOTSTRAP_HH_
