//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestRDAPBootstrap.cc 9458 2017-06-06 05:08:27Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestRDAPBootstrap.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iostream>
#include <Poco/Net/SSLManager.h>

#include "DwmUnitAssert.hh"
#include "DwmRDAPBootstrap.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
#if (POCO_VERSION >= 0x01040200)
  Poco::Net::initializeSSL();
#endif
  RDAP::Bootstrap  bootstrap;
  if (UnitAssert(bootstrap.Load("http://data.iana.org/rdap/ipv4.json"))) {
    Ipv4Address addr("110.1.1.1");
    if (UnitAssert(! bootstrap.RDAPServers(addr).empty())) {
      UnitAssert(bootstrap.RDAPServers(addr).front()
                 == "https://rdap.apnic.net/");
    }
  }

  if (UnitAssert(bootstrap.Load("file:./ipv4.json"))) {
    Ipv4Address addr("110.1.1.1");
    if (UnitAssert(! bootstrap.RDAPServers(addr).empty())) {
      UnitAssert(bootstrap.RDAPServers(addr).front()
                 == "https://rdap.apnic.net/");
    }
  }

  if (Assertions::Total().Failed() > 0) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Assertions::Total() << " passed\n";
  }

}
