
//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestCountryCodes.cc 9458 2017-06-06 05:08:27Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestCountryCodes.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <algorithm>
#include <fstream>

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmCountryCodes.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.1.9/tests/TestCountryCodes.cc 9458 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestMatches(const CountryCodes & cc)
{
  vector<CountryCode>  matches = cc.FindByNameRegExp("^United");
  UnitAssert(matches.size() == 3);
  UnitAssert(find_if(matches.begin(), matches.end(),
                     [&] (const CountryCode & cc) {
                       return ((cc.Name() == "United Arab Emirates")
                               && (cc.Alpha2() == "AE")
                               && (cc.Alpha3() == "ARE"));
                     }) != matches.end());
  UnitAssert(find_if(matches.begin(), matches.end(),
                     [&] (const CountryCode & cc) {
                       return ((cc.Name() == "United Kingdom")
                               && (cc.Alpha2() == "GB")
                               && (cc.Alpha3() == "GBR"));
                     }) != matches.end());
  UnitAssert(find_if(matches.begin(), matches.end(),
                     [&] (const CountryCode & cc) {
                       return ((cc.Name() == "United States of America")
                               && (cc.Alpha2() == "US")
                               && (cc.Alpha3() == "USA"));
                     }) != matches.end());
  return;
}
  
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestJsonIO()
{
  CountryCodes  countryCodes;
  if (UnitAssert(countryCodes.ReadJson("../etc/country_codes.json"))) {
    CountryCode cc = countryCodes.FindByCode("US");
    UnitAssert(cc.Alpha2() == "US");
    UnitAssert(cc.Alpha3() == "USA");
    UnitAssert(cc.Name() == "United States of America");

    cc = countryCodes.FindByCode("NONEXIST");
    UnitAssert(cc.Alpha2().empty()
               && cc.Alpha3().empty()
               && cc.Name().empty());

    TestMatches(countryCodes);
                         
    if (UnitAssert(countryCodes.WriteJson("TestCountryCodes.json"))) {
      CountryCodes  countryCodes2;
      if (UnitAssert(countryCodes2.ReadJson("TestCountryCodes.json"))) {
        cc = countryCodes2.FindByCode("USA");
        UnitAssert(cc.Alpha2() == "US");
        UnitAssert(cc.Alpha3() == "USA");
        UnitAssert(cc.Name() == "United States of America");
        TestMatches(countryCodes2);
      }
      remove("TestCountryCodes.json");
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestStreamIO()
{
  CountryCodes  countryCodes;
  if (UnitAssert(countryCodes.ReadJson("../etc/country_codes.json"))) {
    ofstream  os("TestCountryCodes.out");
    if (os) {
      bool  wrote = false;
      if (countryCodes.Write(os)) {
        wrote = true;
      }
      os.close();
      if (UnitAssert(wrote)) {
        ifstream  is("TestCountryCodes.out");
        if (is) {
          CountryCodes  countryCodes2;
          UnitAssert(countryCodes2.Read(is));
          is.close();
          UnitAssert(countryCodes == countryCodes2);
          TestMatches(countryCodes2);
        }
      }
      remove("TestCountryCodes.out");
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestDescriptorIO()
{
  CountryCodes  countryCodes;
  if (UnitAssert(countryCodes.ReadJson("../etc/country_codes.json"))) {
    int  fd = open("TestCountryCodes.out", O_WRONLY|O_CREAT|O_TRUNC, 0644);
    if (UnitAssert(fd >= 0)) {
      bool  wrote = false;
      if (countryCodes.Write(fd) > 0) {
        wrote = true;
      }
      close(fd);
      if (UnitAssert(wrote)) {
        fd = open("TestCountryCodes.out", O_RDONLY);
        if (UnitAssert(fd >= 0)) {
          CountryCodes  countryCodes2;
          UnitAssert(countryCodes2.Read(fd) > 0);
          close(fd);
          UnitAssert(countryCodes == countryCodes2);
          TestMatches(countryCodes2);
        }
      }
      remove("TestCountryCodes.out");
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestFileIO()
{
  CountryCodes  countryCodes;
  if (UnitAssert(countryCodes.ReadJson("../etc/country_codes.json"))) {
    FILE  *f = fopen("TestCountryCodes.out", "w");
    if (UnitAssert(f)) {
      bool  wrote = false;
      if (countryCodes.Write(f) > 0) {
        wrote = true;
      }
      fclose(f);
      if (UnitAssert(wrote)) {
        f = fopen("TestCountryCodes.out", "r");
        if (UnitAssert(f)) {
          CountryCodes  countryCodes2;
          UnitAssert(countryCodes2.Read(f) > 0);
          fclose(f);
          UnitAssert(countryCodes == countryCodes2);
          TestMatches(countryCodes2);
        }
      }
      remove("TestCountryCodes.out");
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestJsonIO();
  TestStreamIO();
  TestDescriptorIO();
  TestFileIO();
  
  if (Assertions::Total().Failed() > 0) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Assertions::Total() << " passed\n";
  }

}
