//===========================================================================
// @(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.1.9/apps/getasdescrs/getasdescrs.cc 9600 $
// @(#) $Id: getasdescrs.cc 9600 2017-06-22 08:59:30Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file getasdescrs.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include <cstring>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <map>
#include <regex>

#include <Poco/Net/HTTPClientSession.h>
#include <Poco/Net/HTTPRequest.h>
#include <Poco/Net/HTTPResponse.h>
#include <Poco/URI.h>

#include "DwmIO.hh"

using namespace std;
using Poco::URI;
using Poco::Net::HTTPClientSession;
using Poco::Net::HTTPMessage;
using Poco::Net::HTTPRequest;
using Poco::Net::HTTPResponse;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void Usage(const string & argv0)
{
  cerr << "usage: " << argv0 << " [-o outfile]\n";
  return;
}

//----------------------------------------------------------------------------
//!  Fetches and parses the AS descriptions from
//!  http://www.cidr-report.org/as2.0/autnums.html
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  string  outFile;
  int     optChar;
  while ((optChar = getopt(argc, argv, "o:")) != -1) {
    switch (optChar) {
      case 'o':
        outFile = optarg;
        break;
      default:
        Usage(argv[0]);
        return 1;
        break;
    }
  }
  
  Poco::URI          uri("http://www.cidr-report.org/as2.0/autnums.html");
  HTTPClientSession  sess(uri.getHost());
  HTTPRequest        req(HTTPRequest::HTTP_GET, uri.getPathAndQuery(),
                         HTTPMessage::HTTP_1_1);

  regex     rgx("<a href[^>]+AS([0-9]+).+</a>[ ]*(.*),[ ]([A-Za-z][A-Za-z])$",
                regex::ECMAScript|regex::optimize);
  smatch    sm;

  map<uint32_t,string>  asDescrMap;
  
  try {
    ostream & os = sess.sendRequest(req);
    if (os) {
      HTTPResponse  resp;
      istream & is = sess.receiveResponse(resp);
      string    s;
      cout << setiosflags(ios::left);
      while (getline(is, s)) {
        if (regex_search(s, sm, rgx)) {
          if (sm.size() == 4) {
            asDescrMap[stoul(sm[1].str())] = sm[2].str();
          }
        }
      }
      if (! outFile.empty()) {
        ofstream  outos(outFile);
        if (outos) {
          Dwm::IO::Write(outos, asDescrMap);
          outos.close();
        }
        else {
          cerr << "Failed to open " << outFile << ": "
               << strerror(errno) << '\n';
        }
      }
      for (auto asi : asDescrMap) {
        cout << setw(10) << asi.first << ' ' << asi.second << '\n';
      }
    }
  }
  
  catch (Poco::Exception &ex) {
    cerr << "Exception, URI "
         << uri.toString() << ", " << ex.className() << ", "
         << ex.name() << ", " << ex.displayText() << "\n";
  }
}
