%{
  //=========================================================================
  // @(#) $Name:$
  // @(#) $Id:$
  //=========================================================================
  //  Copyright (c) Daniel W. McRobb 2017
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //=========================================================================

  //-------------------------------------------------------------------------
  //!  \file DwmCfg2JsonLex.ll
  //!  \brief lexer for Dwm::Cfg2Json
  //-------------------------------------------------------------------------

  extern "C" {
    #include <stdarg.h>
    #include <stdio.h>
    #include <stdint.h>
    
    void cfg2jsonerror(const char *arg, ...)
    {
      va_list  ap;
      va_start(ap, arg);
      vfprintf(stderr, arg, ap);
      fprintf(stderr, ": %s at line %d\n", yytext, yylineno);
      return;
    }
  }

  #include <string>
  #include <nlohmann/json.hpp>

  #include "DwmCfg2JsonParse.hh"
%}

%option noyywrap
%option prefix="cfg2json"
%option yylineno

%x x_quotedString

%%

<INITIAL>[#].*
<INITIAL>[^;: \t\n{}"]+   { cfg2jsonlval.stringVal =
                              new std::string(yytext);
                            return STRING; }
<INITIAL>[;:{}]           { return yytext[0]; }
<INITIAL>["]              { BEGIN(x_quotedString); return '"'; }
<x_quotedString>[^"]+     { cfg2jsonlval.stringVal =
                              new std::string(yytext);
                            return STRING; }
<x_quotedString>["]       { BEGIN(INITIAL); return '"'; }
<INITIAL>[ \t\n]

%%
