//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.6/tests/TestDwmAuthSymCryptoMessage.cc 9045 $
// @(#) $Id: TestDwmAuthSymCryptoMessage.cc 9045 2017-04-12 10:20:35Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuthSymCryptoMessage.cc
//!  \brief Dwm::Auth::SymCrypto::Message unit tests
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <fstream>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuthSymCryptoMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.6/tests/TestDwmAuthSymCryptoMessage.cc 9045 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Auth;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestStreamIO()
{
  SymCrypto::Message  wmsg("TopSecret!!", "Text to be encrypted in message");
  ofstream  os("./TestDwmAuthSymCryptoMessage.tmp");
  if (UnitAssert(os)) {
    UnitAssert(wmsg.Write(os));
    os.close();
    SymCrypto::Message  rmsg("TopSecret!!");
    ifstream is("./TestDwmAuthSymCryptoMessage.tmp");
    if (UnitAssert(is)) {
      UnitAssert(rmsg.Read(is));
      UnitAssert(wmsg.Value() == rmsg.Value());
      is.close();
    }
    remove("./TestDwmAuthSymCryptoMessage.tmp");
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestDescriptorIO()
{
  SymCrypto::Message  wmsg("TopSecret!!", "Text to be encrypted in message");
  int  fd = open("./TestDwmAuthSymCryptoMessage.tmp", O_WRONLY|O_CREAT, 0600);
  if (UnitAssert(fd >= 0)) {
    UnitAssert(wmsg.Write(fd));
    close(fd);
    SymCrypto::Message  rmsg("TopSecret!!");
    fd = open("./TestDwmAuthSymCryptoMessage.tmp", O_RDONLY);
    if (UnitAssert(fd >= 0)) {
      UnitAssert(rmsg.Read(fd));
      UnitAssert(wmsg.Value() == rmsg.Value());
      close(fd);
    }
    remove("./TestDwmAuthSymCryptoMessage.tmp");
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestFileIO()
{
  SymCrypto::Message  wmsg("TopSecret!!", "Text to be encrypted in message");
  FILE *f = fopen("./TestDwmAuthSymCryptoMessage.tmp", "wb");
  if (UnitAssert(f)) {
    UnitAssert(wmsg.Write(f));
    fclose(f);
    SymCrypto::Message  rmsg("TopSecret!!");
    f = fopen("./TestDwmAuthSymCryptoMessage.tmp", "rb");
    if (UnitAssert(f)) {
      UnitAssert(rmsg.Read(f));
      UnitAssert(wmsg.Value() == rmsg.Value());
      fclose(f);
    }
    remove("./TestDwmAuthSymCryptoMessage.tmp");
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  //  SysLogger::Open("TestDwmAuthSymCryptoMessage", LOG_PERROR, LOG_USER);
  
  TestStreamIO();
  TestDescriptorIO();
  TestFileIO();
  
  int  rc;
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  return rc;
  
}
