//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.4/tests/TestKeyGenTimes.cc 8558 $
// @(#) $Id: TestKeyGenTimes.cc 8558 2016-05-22 17:13:33Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestKeyGenTimes.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iostream>

#include "DwmSvnTag.hh"
#include "DwmTimeValue64.hh"
#include "DwmAuthPKCrypto.hh"

using namespace std;
using namespace Dwm;
using namespace Dwm::Auth;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TimeValue64  startTime(true);
  for (int i = 0; i < 50; ++i) {
    PKCrypto::KeyPair  keyPair = PKCrypto::CreateKeyPair(512);
  }
  TimeValue64  elapsedTime(true);
  elapsedTime -= startTime;
  cout << "512-bit keypairs/sec: " << 50 / ((double)elapsedTime) << '\n';
  cout.flush();

  startTime.SetNow();
  for (int i = 0; i < 50; ++i) {
    PKCrypto::KeyPair  keyPair = PKCrypto::CreateKeyPair(1024);
  }
  elapsedTime.SetNow();
  elapsedTime -= startTime;
  cout << "1024-bit keypairs/sec: " << 50 / ((double)elapsedTime) << '\n';
  cout.flush();
  
  startTime.SetNow();
  for (int i = 0; i < 50; ++i) {
    PKCrypto::KeyPair  keyPair = PKCrypto::CreateKeyPair(2048);
  }
  elapsedTime.SetNow();
  elapsedTime -= startTime;
  cout << "2048-bit keypairs/sec: " << 50 / ((double)elapsedTime) << '\n';
}
