//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.4/tests/TestDwmAuthSymCrypto.cc 9842 $
// @(#) $Id: TestDwmAuthSymCrypto.cc 9842 2017-12-16 23:55:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuthSymCrypto.cc
//!  \brief Unit tests for Dwm::Auth::SymCrypto
//---------------------------------------------------------------------------

#include <cryptopp/osrng.h>

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuthSymCrypto.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.4/tests/TestDwmAuthSymCrypto.cc 9842 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Auth;

static const string  g_keys[] = {
  "WTF?WMC?Idunno!",
  "a12345678901234",
  "#@%$&^()[]abcde",
  ""
};

static const string g_ivs[] = {
  string("12345678"),
  string("abcdEFGH"),
  string("!@#$%^&("),
  string("")
};

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBinary()
{
#ifdef __linux__
  CryptoPP::NonblockingRng  rng;
#else
  CryptoPP::BlockingRng  rng;
#endif

  uint8_t  data[4096];
  rng.GenerateBlock(data, 4096);

  for (int j = 0; (! g_keys[j].empty()); ++j) {
    for (int k = 0; (! g_ivs[k].empty()); ++k) {
      string  cipher = SymCrypto::Encrypt(g_keys[j], g_ivs[k],
                                          data, 4096);
      string  plain = SymCrypto::Decrypt(g_keys[j], g_ivs[k], cipher);
      UnitAssert(memcmp(plain.c_str(), data, 4096) == 0);
      UnitAssert(plain.size() == 4096);
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  const string  plainTexts[] = {
    "Dear Woz: Please start mincing words.  Please.",
    "Oh, and one more thing. Bite me, Yoko. Bite me hard.",
    "Maybe we shouldn't have sued our own customers.",
    ""
  };

  string  plain, cipher;
  for (int i = 0; (! plainTexts[i].empty()); ++i) {
    for (int j = 0; (! g_keys[j].empty()); ++j) {
      for (int k = 0; (! g_ivs[k].empty()); ++k) {
        cipher = SymCrypto::Encrypt(g_keys[j], g_ivs[k], plainTexts[i]);
        plain = SymCrypto::Decrypt(g_keys[j], g_ivs[k], cipher);
        UnitAssert(plain == plainTexts[i]);
      }
    }
  }

  TestBinary();
  
  int  rc;
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  return rc;
}
