//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.4/tests/TestDwmAuthCountedString.cc 8596 $
// @(#) $Id: TestDwmAuthCountedString.cc 8596 2016-05-28 17:29:13Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuthCountedString.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuthCountedString.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.4/tests/TestDwmAuthCountedString.cc 8596 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestDescriptorIO()
{
  string  filename("./TestDwmAuthCountedString.tmp");
  string  value1("String to save to file via descriptor.");
  int  fd = open(filename.c_str(), O_WRONLY|O_CREAT, 0644);
  if (UnitAssert(fd >= 0)) {
    Auth::CountedString  cs = value1;
    UnitAssert(cs.Write(fd));
    close(fd);

    fd = open(filename.c_str(), O_RDONLY);
    if (UnitAssert(fd >= 0)) {
      Auth::CountedString  cs;
      if (UnitAssert(cs.Read(fd))) {
        UnitAssert(cs.Value() == value1);
      }
      close(fd);
    }
    remove(filename.c_str());
  }
  return;
}
        
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestDescriptorIO();

  int  rc = 1;
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  return rc;
}
