//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.3/tests/TestDwmAuthPublicKeysFile.cc 10617 $
// @(#) $Id: TestDwmAuthPublicKeysFile.cc 10617 2020-05-02 21:18:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuthPublicKeysFile.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuthPublicKeysFile.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.3/tests/TestDwmAuthPublicKeysFile.cc 10617 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Auth;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestSaveLoad()
{
  Ed25519::KeyPair  kp1 = Ed25519::CreateKeyPair();
  Ed25519::KeyPair  kp2 = Ed25519::CreateKeyPair();
  Ed25519::KeyPair  kp3 = Ed25519::CreateKeyPair();
  Ed25519::KeyPair  kp4 = Ed25519::CreateKeyPair();
  Ed25519::KeyPair  kp5 = Ed25519::CreateKeyPair();

  PublicKeysFile  pkfile1;
  UnitAssert(pkfile1.AddKey("dwm1@mcplex.net", kp1.Public()));
  UnitAssert(pkfile1.AddKey("dwm2@mcplex.net", kp2.Public()));
  UnitAssert(pkfile1.AddKey("dwm3@mcplex.net", kp3.Public()));
  UnitAssert(pkfile1.AddKey("dwm4@mcplex.net", kp4.Public()));
  UnitAssert(pkfile1.AddKey("dwm5@mcplex.net", kp5.Public()));

  //  Make sure we can't add a key we've already added.
  UnitAssert(! pkfile1.AddKey("dwm2@mcplex.net", kp2.Public()));

  //  Can we remove a key?
  if (UnitAssert(pkfile1.RemoveKey("dwm2@mcplex.net"))) {
    //  Make sure we can't remove a key we've already removed.
    UnitAssert(! pkfile1.RemoveKey("dwm2@mcplex.net"));
  }
  
  if (UnitAssert(pkfile1.Save("./known_services.test"))) {
    PublicKeysFile  pkfile2;
    UnitAssert(pkfile2.Load("./known_services.test"));
    UnitAssert(pkfile2.Keys() == pkfile1.Keys());
    std::remove("./known_services.test");
  }
  
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestSaveLoad();

  int  rc;
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }

  return rc;
}
