//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.3/tests/TestDwmAuth.cc 10617 $
// @(#) $Id: TestDwmAuth.cc 10617 2020-05-02 21:18:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuth.cc
//!  \brief Unit tests for Dwm::Auth::AuthenticateServer and
//!  Dwm::Auth::AuthenticateClient
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
}

#include <thread>

#include "DwmSocket.hh"
#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuth.hh"
#include "DwmAuthCountedString.hh"

static const Dwm::SvnTag  svntag("$DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.3/tests/TestDwmAuth.cc 10617 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void ClientThread()
{
  Socket  s;
  if (UnitAssert(s.Open(PF_INET, SOCK_STREAM, 0))) {
    struct sockaddr_in  sockAddr;
    memset(&sockAddr, 0, sizeof(sockAddr));
#ifndef __linux__
    sockAddr.sin_len = sizeof(sockAddr);
#endif
    sockAddr.sin_family = AF_INET;
    sockAddr.sin_port = htons(2121);
    sockAddr.sin_addr.s_addr = inet_addr("127.0.0.1");
    if (UnitAssert(s.Connect(sockAddr))) {
      Auth::Ed25519::KeyPair  myKeys =
        Auth::Ed25519::CreateKeyPair();
      UnitAssert(AuthenticateServer(s, myKeys, "DwmAuthTest"));
    }
    UnitAssert(s.Close());
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void ServerThread()
{
  Socket  s;
  if (UnitAssert(s.Open(PF_INET, SOCK_STREAM, 0))) {
    struct sockaddr_in  sockAddr;
    memset(&sockAddr, 0, sizeof(sockAddr));
#ifndef __linux__
    sockAddr.sin_len = sizeof(sockAddr);
#endif
    sockAddr.sin_family = AF_INET;
    sockAddr.sin_port = htons(2121);
    sockAddr.sin_addr.s_addr = INADDR_ANY;
    if (UnitAssert(s.Bind(sockAddr))) {
      if (UnitAssert(s.Listen(10))) {
        Socket  as;
        struct sockaddr_in  clientAddr;
        if (UnitAssert(s.Accept(as, clientAddr))) {
          Auth::Ed25519::KeyPair  myKeys =
            Auth::Ed25519::CreateKeyPair();
          UnitAssert(AuthenticateClient(as, myKeys, "DwmAuthTest"));
        }
      }
    }
    UnitAssert(s.Close());
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  //  SysLogger::Open("TestDwmAuth", LOG_PERROR, LOG_USER);

  thread  serverThread(ServerThread);
  sleep(1);
  thread  clientThread(ClientThread);

  clientThread.join();
  serverThread.join();
  
  int  rc;
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  return rc;
}

        
  
