//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.2/include/DwmAuthEd25519Keys.hh 10617 $
// @(#) $Id: DwmAuthEd25519Keys.hh 10617 2020-05-02 21:18:04Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018, 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthEd25519Keys.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMAUTHED25519KEYS_HH_
#define _DWMAUTHED25519KEYS_HH_

#include <string>
#include <cryptopp/cryptlib.h>
#include <cryptopp/xed25519.h>
#include <cryptopp/base64.h>
#include <cryptopp/filters.h>
#include <cryptopp/osrng.h>

#include "DwmReadable.hh"
#include "DwmWritable.hh"

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Ed25519
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      class PublicKey
        : public CryptoPP::ed25519PublicKey,
          public Dwm::Readable, public Dwm::Writable
      {
      public:
        PublicKey()
            : CryptoPP::ed25519PublicKey()
        {}
        
        PublicKey(const CryptoPP::ed25519PublicKey & key)
            : CryptoPP::ed25519PublicKey(key)
        {}

        bool IsValid() const;
        
        std::string ToString() const;
        std::string ToBase64String() const;
        bool FromString(const std::string & s);
        bool FromBase64String(const std::string & s);
        
        std::istream & Read(std::istream & is) override;
        std::ostream & Write(std::ostream & os) const override;
        size_t Read(FILE *f) override;
        size_t Write(FILE *f) const override;
        ssize_t Read(int fd) override;
        ssize_t Write(int fd) const override;
        uint32_t StreamedLength() const override;
        
        //--------------------------------------------------------------------
        //!  operator ==
        //--------------------------------------------------------------------
        bool operator == (const PublicKey & pk) const;
      };

      //----------------------------------------------------------------------
      //!  Encapsulates a readable and writable private key.
      //----------------------------------------------------------------------
      class PrivateKey
        : public CryptoPP::ed25519PrivateKey,
          public Dwm::Readable, public Dwm::Writable
      {
      public:
        PrivateKey()
            : CryptoPP::ed25519PrivateKey()
        {}
        
        PrivateKey(const CryptoPP::ed25519PrivateKey & key)
            : CryptoPP::ed25519PrivateKey(key)
        {}

        bool IsValid() const;

        std::string ToString() const;
        std::string ToBase64String() const;
        bool FromString(const std::string & s);
        bool FromBase64String(const std::string & s);

        std::istream & Read(std::istream & is) override;
        std::ostream & Write(std::ostream & os) const override;
        size_t Read(FILE *f) override;
        size_t Write(FILE *f) const override;
        ssize_t Read(int fd) override;
        ssize_t Write(int fd) const override;
        uint32_t StreamedLength() const override;

        //--------------------------------------------------------------------
        //!  operator ==
        //--------------------------------------------------------------------
        bool operator == (const PrivateKey & pk) const;
      };

      //----------------------------------------------------------------------
      //!  Encapsulates a private/public key pair.
      //----------------------------------------------------------------------
      class KeyPair
        : public std::pair<PrivateKey,PublicKey>
      {
      public:
        //--------------------------------------------------------------------
        //!  Default constructor.
        //--------------------------------------------------------------------
        KeyPair()
            : std::pair<PrivateKey,PublicKey>()
        {}
        
        //--------------------------------------------------------------------
        //!  Construct from a private and public key.
        //--------------------------------------------------------------------
        KeyPair(const PrivateKey & privKey, const PublicKey & publicKey)
            : std::pair<PrivateKey,PublicKey>(privKey,publicKey)
        {}

        //--------------------------------------------------------------------
        //!  operator =
        //--------------------------------------------------------------------
        KeyPair & operator = (const KeyPair & keys)
        {
          if (this != &keys) {
            this->first = keys.first;
            this->second = keys.second;
          }
          return *this;
        }
        
        //--------------------------------------------------------------------
        //!  Returns a const reference to the private key.
        //--------------------------------------------------------------------
        const PrivateKey & Private() const
        {
          return first;
        }
        
        //--------------------------------------------------------------------
        //!  Returns a mutable reference to the private key.
        //--------------------------------------------------------------------
        PrivateKey & Private()
        {
          return first;
        }
        
        //--------------------------------------------------------------------
        //!  Returns a const reference to the public key.
        //--------------------------------------------------------------------
        const PublicKey & Public() const
        {
          return second;
        }
        
        //--------------------------------------------------------------------
        //!  Returns a mutable reference to the public key.
        //--------------------------------------------------------------------
        PublicKey & Public()
        {
          return second;
        }

        bool Load(const std::string & privKeyPath, std::string & name);
      };
      
      //----------------------------------------------------------------------
      //!  Generate a private/public key pair.  The private key is the
      //!  first key, the public key is the second key.
      //----------------------------------------------------------------------
      static KeyPair CreateKeyPair();
    };
    
  }  // namespace Auth

}  // namespace Dwm

#endif  // _DWMAUTHED25519KEYS_HH_
