//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.13/include/DwmAuthUtils.hh 10973 $
// @(#) $Id: DwmAuthUtils.hh 10973 2020-08-25 02:48:22Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthUtils.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Auth::Utils class declaration
//---------------------------------------------------------------------------

#ifndef _DWMAUTHUTILS_HH_
#define _DWMAUTHUTILS_HH_

#include <chrono>
#include <cstdint>
#include <iostream>
#include <string>

#include <boost/asio.hpp>

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  Collection of utility functions.
    //------------------------------------------------------------------------
    class Utils
    {
    public:
      using Clock = std::chrono::system_clock;
      using TimePoint = std::chrono::time_point<Clock>;
      
      static int BytesReady(int fd);

      static std::size_t BytesReady(boost::asio::ip::tcp::socket & sck);
      
      static bool
      WaitUntilBytesReady(int fd, uint32_t numBytes, TimePoint endTime);

      static bool WaitUntilBytesReady(boost::asio::ip::tcp::socket & sck,
                                      uint32_t numBytes, TimePoint endTime);
      
      static bool WaitForBytesReady(int fd, uint32_t numBytes,
                                    std::chrono::milliseconds timeout);
      
      static bool WaitForBytesReady(boost::asio::ip::tcp::socket & sck,
                                    uint32_t numBytes,
                                    std::chrono::milliseconds timeout);
          
      static ssize_t ReadLengthRestrictedString(int fd, std::string & s,
                                                uint32_t maxLen);

      static ssize_t
      ReadLengthRestrictedString(boost::asio::ip::tcp::socket & sck,
                                 std::string & s, uint32_t maxLen);
      
      static std::istream & ReadLengthRestrictedString(std::istream & is,
                                                       std::string & s,
                                                       uint32_t maxLen);
      
      static ssize_t
      ReadLengthRestrictedString(int fd, std::string & s, uint32_t maxLen,
                                 std::chrono::milliseconds timeout);
      
      static ssize_t
      ReadLengthRestrictedString(int fd, std::string & s,
                                 uint32_t maxLen, TimePoint endTime);

      static ssize_t
      ReadLengthRestrictedString(boost::asio::ip::tcp::socket & sck,
                                 std::string & s, uint32_t maxLen,
                                 TimePoint endTime);
      };
    
  }  // namespace Auth

}  // namespace Dwm

#endif  // _DWMAUTHUTILS_HH_
