//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.12/include/DwmAuthSymCrypto.hh 9798 $
// @(#) $Id: DwmAuthSymCrypto.hh 9798 2017-11-07 00:43:11Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthSymCrypto.hh
//!  \brief Symmetric crypto utility definitions
//---------------------------------------------------------------------------

#ifndef _DWMAUTHSYMCRYPTO_HH_
#define _DWMAUTHSYMCRYPTO_HH_

#include <string>

namespace Dwm {

  namespace Auth {

    namespace SymCrypto {

      //----------------------------------------------------------------------
      //!  Encrypts the given @c plaintext using AES.  @c keystr is ideally
      //!  16 bytes long.  If shorter, we will pad to 16 bytes by repeating
      //!  the contents of @c keystr starting at index 0.  @c ivstr is
      //!  ideally 16 bytes long.  If shorter, we will pad to 16 bytes by
      //!  repeating the contents of @c ivstr starting at index 0.
      //!  Returns the encrypted string.
      //----------------------------------------------------------------------
      std::string Encrypt(const std::string & keystr,
                          const std::string & ivstr,
                          const std::string & plaintext);

      //----------------------------------------------------------------------
      //!  Encrypts the given @c plantextLen bytes of @c plaintext using AES.
      //!  @c keystr is ideally 16 bytes long.  If shorter, we will pad to 16
      //!  bytes by repeating the contents of @c keystr starting at index 0.
      //!  @c ivstr is ideally 16 bytes long.  If shorter, we will pad to 16
      //!  bytes by repeating the contents of @c ivstr starting at index 0.
      //!  Returns the encrypted string.
      //----------------------------------------------------------------------
      std::string Encrypt(const std::string & keystr,
                          const std::string & ivstr,
                          const uint8_t *plaintext,
                          size_t plaintextLen);

      //----------------------------------------------------------------------
      //!  Decrypts the given @c ciphertext using AES.  @c keystr is ideally
      //!  16 bytes long.  If shorter, we will pad to 16 bytes by repeating
      //!  the contents of @c keystr starting at index 0.  @c ivstr is
      //!  ideally 16 bytes long.  If shorter, we will pad to 16 bytes by
      //!  repeating the contents of @c ivstr starting at index 0.
      //!  Returns the decrypted string.
      //----------------------------------------------------------------------
      std::string Decrypt(const std::string & keystr,
                          const std::string & ivstr,
                          const std::string & ciphertext);
      
    }  // namespace SymCrypto
      
  }  // namespace Auth

}  // namespace Dwm

#endif  // _DWMAUTHSYMCRYPTO_HH_
