//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.3.12/include/DwmAuthCountedString.hh 11162 $
// @(#) $Id: DwmAuthCountedString.hh 11162 2020-09-08 06:46:41Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthCountedString.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMAUTHCOUNTEDSTRING_HH_
#define _DWMAUTHCOUNTEDSTRING_HH_

#include <string>

#include "DwmDescriptorIOCapable.hh"
#include "DwmFileIOCapable.hh"
#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class CountedString
      : public DescriptorIOCapable, public FileIOCapable,
        public StreamIOCapable, public StreamedLengthCapable
    {
    public:
      CountedString() = default;
      CountedString(const std::string & s)
          : _s(s)
      {}

      operator const std::string & () const
      {
        return _s;
      }
      
      operator std::string & ()
      {
        return _s;
      }

      const std::string & Value() const
      {
        return _s;
      }

      const std::string & Value(const std::string & v)
      {
        _s = v;
        return _s;
      }

      std::istream & Read(std::istream & is) override;
      std::ostream & Write(std::ostream & os) const override;
      ssize_t Read(int fd) override;
      ssize_t Write(int fd) const override;
      size_t Read(FILE *f) override;
      size_t Write(FILE *f) const override;
      uint32_t StreamedLength() const override;

    private:
      std::string  _s;
    };
    
  }  // namespace Auth

}  // namespace Dwm

#endif  // _DWMAUTHCOUNTEDSTRING_HH_
