//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.2.1/src/DwmAuthCountedString.cc 8596 $
// @(#) $Id: DwmAuthCountedString.cc 8596 2016-05-28 17:29:13Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthCountedString.cc
//!  \brief Dwm::Auth::CountedString implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include <cstdlib>

#include "DwmSvnTag.hh"
#include "DwmIO.hh"
#include "DwmAuthCountedString.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.2.1/src/DwmAuthCountedString.cc 8596 $");

using namespace std;

namespace Dwm {

  namespace Auth {
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & CountedString::Read(std::istream & is)
    {
      _s.clear();
      if (is) {
        uint32_t  len;
        if (IO::Read(is, len)) {
          char  *buf = (char *)calloc(1, len);
          if (buf) {
            is.read(buf, len);
            _s.assign(buf, len);
            free(buf);
          }
        }
      }
      return is;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & CountedString::Write(std::ostream & os) const
    {
      if (os) {
        uint32_t  len = _s.size();
        if (IO::Write(os, len)) {
          os.write((const char *)_s.data(), len);
        }
      }
      return os;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t CountedString::Read(int fd)
    {
      _s.clear();
      ssize_t  rc = -1;
      if (fd >= 0) {
        uint32_t len;
        ssize_t  bytesRead = IO::Read(fd, len);
        if (bytesRead == sizeof(len)) {
          rc = bytesRead;
          char  *buf = (char *)calloc(1, len);
          if (buf) {
            bytesRead = read(fd, buf, len);
            if (bytesRead == len) {
              _s.assign(buf, len);
              rc += bytesRead;
            }
            else {
              rc = -1;
            }
            free(buf);
          }
          else {
            rc = -1;
          }
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t CountedString::Write(int fd) const
    {
      ssize_t  rc = -1;
      if (fd >= 0) {
        uint32_t  len = _s.size();
        ssize_t  bytesWritten = IO::Write(fd, len);
        if (bytesWritten == sizeof(len)) {
          rc = bytesWritten;
          bytesWritten = write(fd, _s.data(), len);
          if (bytesWritten == len) {
            rc += bytesWritten;
          }
          else {
            rc = -1;
          }
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t CountedString::Read(FILE *f)
    {
      _s.clear();
      size_t  rc = 0;
      if (f) {
        uint32_t  len;
        if (IO::Read(f, len)) {
          char  *buf = (char *)calloc(1, len);
          if (buf) {
            if (fread(buf, len, 1, f) == 1) {
              _s.assign(buf, len);
              rc = 1;
            }
            free(buf);
          }
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t CountedString::Write(FILE *f) const
    {
      size_t  rc = 0;
      if (f) {
        uint32_t  len = _s.size();
        if (IO::Write(f, len)) {
          if (fwrite(_s.data(), len, 1, f) == 1) {
            rc = 1;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t CountedString::StreamedLength() const
    {
      return (sizeof(uint32_t) + _s.size());
    }
    
    
  }  // namespace Auth

}  // namespace Dwm
