//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.2.1/include/DwmAuthSymCryptoMessage.hh 9813 $
// @(#) $Id: DwmAuthSymCryptoMessage.hh 9813 2017-12-11 07:23:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthSymCryptoMessage.hh
//!  \brief Dwm::Auth::SymCrypto::Message definition
//---------------------------------------------------------------------------

#ifndef _DWMAUTHSYMCRYPTOMESSAGE_HH_
#define _DWMAUTHSYMCRYPTOMESSAGE_HH_

#include <string>

#include <cryptopp/aes.h>

#include "DwmReadable.hh"
#include "DwmSocket.hh"
#include "DwmWritable.hh"

namespace Dwm {

  namespace Auth {

    namespace SymCrypto {

      //----------------------------------------------------------------------
      //!  Encapsulates an encrypted message.
      //----------------------------------------------------------------------
      class Message
        : public Readable, public Writable
      {
      public:
        //--------------------------------------------------------------------
        //!  Constructor with the given @c secret and @c value.
        //--------------------------------------------------------------------
        Message(const std::string & secret, const std::string & value = "");

        //--------------------------------------------------------------------
        //!  Destructor.
        //--------------------------------------------------------------------
        ~Message();
        
        //--------------------------------------------------------------------
        //!  Returns the decrypted value.
        //--------------------------------------------------------------------
        std::string Value() const;
        
        //--------------------------------------------------------------------
        //!  Sets the contained value by encrypting the given @c value.
        //--------------------------------------------------------------------
        const std::string & Value(const std::string & value);
        
        //--------------------------------------------------------------------
        //!  Reads the message from an istream.  Returns the istream.
        //--------------------------------------------------------------------
        std::istream & Read(std::istream & is);
        
        //--------------------------------------------------------------------
        //!  Writes the message to an ostream.  Returns the ostream.
        //--------------------------------------------------------------------
        std::ostream & Write(std::ostream & os) const;
        
        //--------------------------------------------------------------------
        //!  Reads the message from a file descriptor.  Returns the numbers of
        //!  bytes read on success, -1 on failure.
        //--------------------------------------------------------------------
        ssize_t Read(int fd);
        
        //--------------------------------------------------------------------
        //!  Writes the message to a file descriptor.  Returns the number of
        //!  bytes written on success, -1 on failure.
        //--------------------------------------------------------------------
        ssize_t Write(int fd) const;
        
        //--------------------------------------------------------------------
        //!  Reads the message from a FILE.  Returns 1 on success, 0 on
        //!  failure.
        //--------------------------------------------------------------------
        size_t Read(FILE *f);
        
        //--------------------------------------------------------------------
        //!  Writes the message to a FILE.  Returns 1 on success, 0 on
        //!  failure.
        //--------------------------------------------------------------------
        size_t Write(FILE *f) const;
        
        //--------------------------------------------------------------------
        //!  Returns the number of bytes that would be written if one of
        //!  the Write() members were called.
        //--------------------------------------------------------------------
        uint32_t StreamedLength() const;

        ssize_t SendTo(Socket & s, int flags,
                       const Ipv4Address & dstAddr, uint16_t dstPort);
        ssize_t RecvFrom(Socket & s, int flags,
                         Ipv4Address & srcAddr, uint16_t & srcPort);
        
      private:
        std::string  _secret;
        uint8_t      _iv[CryptoPP::AES::BLOCKSIZE];
        std::string  _msg;

        ssize_t ReadMsgValue(int fd);
        ssize_t WriteMsgValue(int fd) const;
        std::istream & ReadMsgValue(std::istream & is);
        std::ostream & WriteMsgValue(std::ostream & os) const;
        size_t ReadMsgValue(FILE *f);
        size_t WriteMsgValue(FILE *f) const;
      };
      
    }  // namespace SymCrypto

  }  // namespace Auth
  
}  // namespace Dwm

#endif  // _DWMAUTHSYMCRYPTOMESSAGE_HH_
