//===========================================================================
// @(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.1.3/tests/TestDwmAuthSymCrypto.cc 8556 $
// @(#) $Id: TestDwmAuthSymCrypto.cc 8556 2016-05-22 14:43:14Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmAuthSymCrypto.cc
//!  \brief Unit tests for Dwm::Auth::SymCrypto
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmAuthSymCrypto.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.1.3/tests/TestDwmAuthSymCrypto.cc 8556 $");

using namespace std;
using namespace Dwm;
using namespace Dwm::Auth;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  const string  plainTexts[] = {
    "Dear Woz: Please start mincing words.  Please.",
    "Oh, and one more thing. Bite me, Yoko. Bite me hard.",
    "Maybe we shouldn't have sued our own customers.",
    ""
  };

  const string  keys[] = {
    "WTF?WMC?Idunno!",
    "a12345678901234",
    "#@%$&^()[]abcde",
    ""
  };

  const string ivs[] = {
    string("12345678"),
    string("abcdEFGH"),
    string("!@#$%^&("),
    string("")
  };

  string  plain, cipher;
  for (int i = 0; (! plainTexts[i].empty()); ++i) {
    for (int j = 0; (! keys[j].empty()); ++j) {
      for (int k = 0; (! ivs[k].empty()); ++k) {
        cipher = SymCrypto::Encrypt(keys[j], ivs[k], plainTexts[i]);
        plain = SymCrypto::Decrypt(keys[j], ivs[k], cipher);
        UnitAssert(plain == plainTexts[i]);
      }
    }
  }

  int  rc;
  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }
  return rc;
}
