//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmAuthPublicKeysFile.cc 8992 2017-04-08 13:05:45Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthPublicKeysFile.cc
//!  \brief Dwm::Auth::PublicKeysFile implementation
//---------------------------------------------------------------------------

#include <fstream>
#include <regex>

#include "DwmSvnTag.hh"
#include "DwmAuthPublicKeysFile.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.1.3/src/DwmAuthPublicKeysFile.cc 8992 $");

using namespace std;

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PublicKeysFile::PublicKeysFile()
        : _keys()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool PublicKeysFile::Load(const string & fileName)
    {
      bool  rc = false;
      _keys.clear();
      ifstream  is(fileName.c_str());
      if (is) {
        regex   rgx("([^ \\t]+)[ \t]+([^ \\t]+)",
                    regex::ECMAScript|regex::optimize);
        smatch  sm;
        string  s;
        while (getline(is, s, '\n')) {
          if (regex_search(s, sm, rgx)) {
            if (sm.size() == 3) {
              PKCrypto::PublicKey  pk;
              if (pk.FromBase64String(sm[2].str())) {
                if (pk.IsValid()) {
                  _keys[sm[1].str()] = pk;
                }
              }
            }
          }
        }
        is.close();
      }
      return (! _keys.empty());
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PublicKeysFile::Map::const_iterator
    PublicKeysFile::Find(const string & name) const
    {
      return _keys.find(name);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const PublicKeysFile::Map & PublicKeysFile::Keys() const
    {
      return _keys;
    }
    
    
  }  // namespace Auth

}  // namespace Dwm
