//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmAuthECDHAgreement.cc 8996 2017-04-10 05:49:58Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmAuthECDHAgreement.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <cryptopp/eccrypto.h>
#include <cryptopp/oids.h>
#include <cryptopp/osrng.h>

#include "DwmSvnTag.hh"
#include "DwmAuthECDHAgreement.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmAuth/tags/libDwmAuth-0.1.3/src/DwmAuthECDHAgreement.cc 8996 $");

namespace Dwm {

  namespace Auth {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ECDHAgreement::ECDHAgreement()
        : _dh(CryptoPP::ASN1::secp256r1()), _theirpub(), _agreedKey()
    {
      CryptoPP::AutoSeededRandomPool  rng;
      _mypub = CryptoPP::SecByteBlock(_dh.PublicKeyLength());
      _mypriv = CryptoPP::SecByteBlock(_dh.PrivateKeyLength());
      _dh.GenerateKeyPair(rng, _mypriv, _mypub);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const CryptoPP::SecByteBlock & ECDHAgreement::Public() const
    {
      return _mypub;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const CryptoPP::SecByteBlock & ECDHAgreement::Private() const
    {
      return _mypriv;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const CryptoPP::SecByteBlock & ECDHAgreement::TheirPublic() const
    {
      return _theirpub;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const CryptoPP::SecByteBlock &
    ECDHAgreement::TheirPublic(const CryptoPP::SecByteBlock & theirPub)
    {
      _theirpub = theirPub;
      return _theirpub;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const CryptoPP::SecByteBlock & ECDHAgreement::AgreedKey() const
    {
      return _agreedKey;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ECDHAgreement::Agree()
    {
      _agreedKey.CleanNew(_dh.AgreedValueLength());
      return _dh.Agree(_agreedKey, _mypriv, _theirpub);
    }
    
    
  }  // namespace Auth

}  // namespace Dwm
