//===========================================================================
// @(#) $DwmPath$
// @(#) $Id$
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDebPkgVersion.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmDebPkgVersion.hh"
#include "DwmUnitAssert.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestFromString()
{
  DebPkgVersion  dpv1;
  if (UnitAssert(! dpv1.FromString(""))) {
    UnitAssert(dpv1.Epoch() == 0);
    UnitAssert(((string)dpv1.Version()).empty());
    UnitAssert(dpv1.Release().empty());
  }

  UnitAssert(dpv1.FromString("0.8.8"));
  UnitAssert(dpv1.Epoch() == 0);
  UnitAssert((string)dpv1.Version() == "0.8.8");
  UnitAssert(dpv1.Release().empty());

  UnitAssert(dpv1.FromString("3:1.2.34"));
  UnitAssert(dpv1.Epoch() == 3);
  UnitAssert((string)dpv1.Version() == "1.2.34");
  UnitAssert(dpv1.Release().empty());

  UnitAssert(dpv1.FromString("1.2.34-0ubuntu1.2"));
  UnitAssert(dpv1.Epoch() == 0);
  UnitAssert((string)dpv1.Version() == "1.2.34");
  UnitAssert(dpv1.Release() == "0ubuntu1.2");
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestConstructors()
{
  DebPkgVersion  dpv1("3.4.5");
  UnitAssert(dpv1.Epoch() == 0);
  UnitAssert((string)dpv1.Version() == "3.4.5");
  UnitAssert(dpv1.Release().empty());

  DebPkgVersion  dpv2(4, "4.5.6");
  UnitAssert(dpv2.Epoch() == 4);
  UnitAssert((string)dpv2.Version() == "4.5.6");
  UnitAssert(dpv2.Release().empty());

  DebPkgVersion  dpv3("5.6.7", "10ubuntu20");
  UnitAssert(dpv3.Epoch() == 0);
  UnitAssert((string)dpv3.Version() == "5.6.7");
  UnitAssert(dpv3.Release() == "10ubuntu20");
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestGreater()
{
  DebPkgVersion  dpv1("3.4.5");
  DebPkgVersion  dpv2("3.4.12");
  UnitAssert(dpv2 > dpv1);

  dpv1.Epoch(1);
  UnitAssert(dpv1 > dpv2);

  DebPkgVersion  dpv3;
  DebPkgVersion  dpv4("1.0.1");
  UnitAssert(dpv4 > dpv3);

  DebPkgVersion  dpv5("1.0");
  DebPkgVersion  dpv6("1.0.1");
  UnitAssert(dpv6 > dpv5);

  dpv5.Version(VersionString("2.4.5"));
  dpv6.Version(VersionString("3.0"));
  UnitAssert(dpv6 > dpv5);
  
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestEqual()
{
  DebPkgVersion  dpv1(2, "3.4.5", "10ubuntu20");
  DebPkgVersion  dpv2 = dpv1;
  UnitAssert(dpv1 == dpv2);
  dpv2.Epoch(0);
  UnitAssert(! (dpv1 == dpv2));
  dpv2.Epoch(2);
  dpv2.Version(VersionString("3.4.6"));
  UnitAssert(! (dpv1 == dpv2));
  dpv2.Version(VersionString("3.4.5"));
  dpv2.Release("10ubuntu21");
  UnitAssert(! (dpv1 == dpv2));
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestNotEqual()
{
  DebPkgVersion  dpv1(2, "3.4.5", "10ubuntu20");
  DebPkgVersion  dpv2 = dpv1;
  UnitAssert(! (dpv1 != dpv2));
  dpv2.Epoch(0);
  UnitAssert(dpv1 != dpv2);
  dpv2.Epoch(2);
  dpv2.Version(VersionString("3.4.6"));
  UnitAssert(dpv1 != dpv2);
  dpv2.Version(VersionString("3.4.5"));
  dpv2.Release("10ubuntu21");
  UnitAssert(dpv1 != dpv2);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestConstructors();
  TestFromString();
  TestGreater();
  TestEqual();
  TestNotEqual();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
  }
}
