//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.9.4/include/DwmDebPkgDepend.hh 11467 $
// @(#) $Id: DwmDebPkgDepend.hh 11467 2020-12-16 02:54:20Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDebPkgDepend.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::DebPkgDepend class declaration
//---------------------------------------------------------------------------

#ifndef _DWMDEBPKGDEPEND_HH_
#define _DWMDEBPKGDEPEND_HH_

#include "DwmDebPkgVersion.hh"

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  class DebPkgDepend
  {
  public:
    DebPkgDepend() = default;

    DebPkgDepend(const std::string & pkg)
        : _pkg(pkg), _operator(), _version()
    {}
    
    DebPkgDepend(const std::string & pkg, const std::string & op,
                 const DebPkgVersion & version)
        : _pkg(pkg), _operator(op), _version(version)
    {}

    const std::string & Package() const
    { return _pkg; }

    const std::string & Package(const std::string & package);
    
    const std::string & Operator() const
    { return _operator; }

    const std::string & Operator(const std::string & op);
    
    const DebPkgVersion & Version() const
    { return _version; }

    const DebPkgVersion & Version(const DebPkgVersion & dpv);
    
    static DebPkgVersion InstalledVersion(const std::string & pkg);

    bool operator < (const DebPkgDepend & dpd) const;

    bool operator == (const DebPkgDepend & dpd) const;
    
    friend std::ostream & operator << (std::ostream & os,
                                       const DebPkgDepend & dep);
    
  private:
    std::string    _pkg;
    std::string    _operator;
    DebPkgVersion  _version;
  };
  
}  // namespace Dwm

#endif  // _DWMDEBPKGDEPEND_HH_
