//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.9.4/include/DwmDaemonUtils.hh 11092 $
// @(#) $Id: DwmDaemonUtils.hh 11092 2020-09-07 17:40:57Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 1998-2007, 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//    endorse or promote products derived from this software without
//    specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDaemonUtils.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::DaemonUtils class definition
//---------------------------------------------------------------------------

#ifndef _DWMDAEMONUTILS_HH_
#define _DWMDAEMONUTILS_HH_

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  Tiny collection of utilities for daemon processes.
  //--------------------------------------------------------------------------
  class DaemonUtils
  {
  public:
    //------------------------------------------------------------------------
    //!  Become a daemon.  Fork, disassociate from process group, ignore
    //!  terminal I/O signals, disassociate from control terminal, close
    //!  stdin and stdout.
    //------------------------------------------------------------------------
    static void Daemonize();
  };
  
  
}  // namespace Dwm

#endif  // _DWMDAEMONUTILS_HH_

//---------------------------- emacs settings -----------------------------
//  Local Variables:
//  mode: C++/la
//  tab-width: 2
//  indent-tabs-mode: nil
//  c-basic-offset: 2
//  End:
//-------------------------------------------------------------------------
