%{
  #include <map>
  #include <string>

  #include "DwmSvnTag.hh"
  #include "DwmDebControlParser.hh"

  static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwm/tags/libDwm-0.9.4/apps/mkdebcontrol/DwmDebControlLexer.lex 11491 $");
  
  extern std::string  g_debPath;
  
  extern "C" {
    #include <stdarg.h>

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void dwmdebctrlerror(const char *arg, ...)
    {
      va_list  ap;
      va_start(ap, arg);
      vfprintf(stderr, arg, ap);
      fprintf(stderr, ": '%s' at line %d of %s\n",
              yytext, yylineno, g_debPath.c_str());
      return;
    }
  }

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  static const std::map<std::string,int>  g_fieldNames = {
    { "Architecture:",      FIELDNAME  },
    { "Breaks:",            FIELDNAME  },
    { "Build-Depends:",     FIELDNAME  },
    { "Conflicts:",         FIELDNAME  },
    { "Depends:",           DEPENDS    },
    { "Description:",       FIELDNAME  },
    { "Enhances:",          FIELDNAME  },
    { "Homepage:",          FIELDNAME  },
    { "Maintainer:",        FIELDNAME  },
    { "Package:",           FIELDNAME  },
    { "Pre-Depends:",       PREDEPENDS },
    { "Priority:",          FIELDNAME  },
    { "Recommends:",        FIELDNAME  },
    { "Replaces:",          FIELDNAME  },
    { "Section:",           FIELDNAME  },
    { "Standards-Version:", FIELDNAME  },
    { "Suggests:",          FIELDNAME  },
    { "Version:",           FIELDNAME  }
  };

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  static bool IsKnownField(const std::string & s, int & field)
  {
    bool  rc = false;
    auto  iter = g_fieldNames.find(s);
    if (iter != g_fieldNames.end()) {
      field = iter->second;
      rc = true;
    }
    return rc;
  }

%}

%option noyywrap
%option prefix="dwmdebctrl"
%option yylineno

%x x_colon
%x x_dependList
%x x_predepends
%x x_value
   
%%

<INITIAL>^[^ \t\n:]+[:]           { int token;
                                    if (IsKnownField(yytext, token)) {
                                      if ((token == DEPENDS)
                                          || (token == PREDEPENDS)) {
                                        BEGIN(x_dependList);
                                      }
                                      else {
                                        dwmdebctrllval.stringVal =
                                          new std::string(yytext);
                                        BEGIN(x_value);
                                      }
                                      return token;
                                    }
                                    else {
                                      dwmdebctrllval.stringVal =
                                        new std::string(yytext);
                                      if (dwmdebctrllval.stringVal->back()
                                          == ':') {
                                        dwmdebctrllval.stringVal->pop_back();
                                      }
                                      BEGIN(x_value);
                                      return UNKNOWNFIELDNAME;
                                    }
                                  }
<x_dependList>[^ \t\n,()><=]+     { dwmdebctrllval.stringVal =
                                      new std::string(yytext);
                                    return STRING;
                                  }
<x_dependList>[,()><=]            { return yytext[0]; }
<x_dependList>[\n][ \t]+
<x_dependList>[\n]/[^ \t]+        { BEGIN(INITIAL); }
<x_dependList>[ \n]
<x_value>[^ \n][^\n]*/[\n]        { dwmdebctrllval.stringVal =
                                      new std::string(yytext);
                                    return STRING;
                                  }
<x_value>[\n][ \t]+               { dwmdebctrllval.stringVal =
                                      new std::string(yytext);
                                    return STRING;
                                  }
<x_value>[\n]/[^ \t]              { BEGIN(INITIAL); }
<x_value>[ \n]
<INITIAL>[ \n]

%%

                                  
