//===========================================================================
// @(#) $DwmPath$
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2008
//  All rights reserved.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmXmlAttribute.cc
//!  \brief Dwm::Xml::Attribute class implementation
//---------------------------------------------------------------------------

#include <string>

#include "DwmXmlAttribute.hh"

using namespace std;

namespace Dwm {

  namespace Xml {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute()
        : _name(""), _value("")
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute(const Attribute & attribute)
        : _name(attribute._name), _value(attribute._value)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute(const std::string & name,
                         const std::string & value)
        : _name(name), _value(value)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Name() const
    {
      return(_name);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Value() const
    {
      return(_value);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Value(const std::string & value)
    {
      _value = value;
      return(_value);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & operator << (std::ostream & os,
                                const Dwm::Xml::Attribute & attribute)
    {
      if (os) {
        os << attribute._name << "=\"" << attribute._value << "\"";
      }
      return(os);
    }
    
  }  // namespace Xml

}  // namespace Dwm


//---------------------------- emacs settings -----------------------------
//  Local Variables:
//  mode: C++
//  tab-width: 2
//  indent-tabs-mode: nil
//  c-basic-offset: 2
//  End:
//-------------------------------------------------------------------------
