//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.8.7/include/DwmStreamedLengthCapable.hh 11087 $
// @(#) $Id: DwmStreamedLengthCapable.hh 11087 2020-09-07 09:58:37Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmStreamedLengthCapable.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::StreamedLengthCapable pure virtual class declaration
//---------------------------------------------------------------------------

#ifndef _DWMSTREAMEDLENGTHCAPABLE_HH_
#define _DWMSTREAMEDLENGTHCAPABLE_HH_

#include <cstdint>

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  Interface for classes which can return their streamed length.  This
  //!  is often an expensive operation on variable-length data structures,
  //!  but is useful when we want to store the length of a piece of data
  //!  before the data itself, since it allows us to skip over the data (or
  //!  just treeat it as an opaque blob) without interpreting it.
  //--------------------------------------------------------------------------
  class StreamedLengthCapable
  {
  public:
    //------------------------------------------------------------------------
    //!  Return the number of bytes that would be written if the object's
    //!  Write(ostream &), Write(FILE *) or Write(int) member were called.
    //!  These members would be inherited from StreamWritable, FileWritable
    //!  or DescriptorWritable, respectively.
    //------------------------------------------------------------------------
    virtual uint32_t StreamedLength() const = 0;
  };
  
}  // namespace Dwm

#endif  // _DWMSTREAMEDLENGTHCAPABLE_HH_
