//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.8.1/include/DwmDescriptorReadable.hh 11083 $
// @(#) $Id: DwmDescriptorReadable.hh 11083 2020-09-06 03:52:47Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2004-2007, 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//    endorse or promote products derived from this software without
//    specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER 
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
//  PURPOSE, OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY 
//  PATENT, TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDescriptorReadable.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::DescriptorReadable pure virtual class declaration
//---------------------------------------------------------------------------

#ifndef _DWMDESCRIPTORREADABLE_HH_
#define _DWMDESCRIPTORREADABLE_HH_

#include <cstddef>

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  This class defines an interface for classes that can read their
  //!  contents from a file descriptor.
  //--------------------------------------------------------------------------
  class DescriptorReadable
  {
  public:
    //------------------------------------------------------------------------
    //!  destructor
    //------------------------------------------------------------------------
    virtual ~DescriptorReadable() { }

    //------------------------------------------------------------------------
    //!  Read from a file descriptor.  Returns the number of bytes read on
    //!  success, -1 on failure.
    //------------------------------------------------------------------------
    virtual ssize_t Read(int fd) = 0;
  };
  
}  // namespace Dwm

#endif  // _DWMDESCRIPTORREADABLE_HH_

//---------------------------- emacs settings -----------------------------
//  Local Variables:
//  mode: C++/la
//  tab-width: 2
//  indent-tabs-mode: nil
//  c-basic-offset: 2
//  End:
//-------------------------------------------------------------------------
