//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.7.1/tests/TestIOSet.cc 8389 $
// @(#) $Id: TestIOSet.cc 8389 2016-04-17 04:31:36Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2005-2007, 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestIOSet.cc
//!  \brief Unit tests for Dwm::IO with sets
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <stdlib.h>
  #include <unistd.h>
}

#include <cstdio>
#include <fstream>

#include "DwmIO.hh"
#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwm/tags/libDwm-0.7.1/tests/TestIOSet.cc 8389 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  set<std::string>  set1;
  
  set1.insert("1");
  set1.insert("2");
  set1.insert("3");
  
  ofstream  os("/tmp/DwmTestIOSet.store");
  if (os) {
    if (! IO::Write(os, set1)) {
      cerr << "Failed to write set1!" << endl;
      exit(1);
    }
    os.close();
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for writing!" << endl;
    exit(1);
  }
  
  set<std::string>  set2;
  ifstream  is("/tmp/DwmTestIOSet.store");
  if (is) {
    if (! IO::Read(is, set2)) {
      cerr << "Failed to read set2!" << endl;
      exit(1);
    }
    is.close();
    std::remove("/tmp/DwmTestIOSet.store");
    
    UnitAssert(set2 == set1);
    UnitAssert(set1.size() == 3);
    
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for reading!" << endl;
    exit(1);
  }

  set<std::string>  set3 = set1;
  int  fd = open("/tmp/DwmTestIOSet.store",O_WRONLY|O_CREAT,0666);
  if (fd >= 0) {
    if (! IO::Write(fd, set3)) {
      cerr << "Failed to write set3 to descriptor!" << endl;
      exit(1);
    }
    close(fd);
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for writing!" << endl;
    exit(1);
  }
  
  fd = open("/tmp/DwmTestIOSet.store",O_RDONLY);
  if (fd >= 0) {
    if (! IO::Read(fd, set2)) {
      cerr << "Failed to read set2 from descriptor!" << endl;
      exit(1);
    }
    close(fd);
    UnitAssert (set2 == set3);
    UnitAssert(set2.size() == 3);
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for reading!" << endl;
    exit(1);
  }
    
  std::remove("/tmp/DwmTestIOSet.store");

  FILE  *f = fopen("/tmp/DwmTestIOSet.store","w");
  if (f) {
    if (! IO::Write(f, set1)) {
      cerr << "Failed to write set1 to FILE!" << endl;
      exit(1);
    }
    fclose(f);
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for writing!" << endl;
    exit(1);
  }
  
  set3.clear();
  f = fopen("/tmp/DwmTestIOSet.store","r");
  if (f) {
    if (! IO::Read(f, set3)) {
      cerr << "Failed to read set3 to FILE!" << endl;
      exit(1);
    }
    fclose(f);
    UnitAssert (set2 == set3);
    UnitAssert(set3.size() == 3);
  }
  else {
    cerr << "Failed to open '/tmp/DwmTestIOSet.store' for reading!" << endl;
    exit(1);
  }

  std::remove("/tmp/DwmTestIOSet.store");
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
  }
  
  return(0);
}
