//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.7.0/include/DwmASIOWritable.hh 10964 $
// @(#) $Id: DwmASIOWritable.hh 10964 2020-08-24 07:08:29Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018, 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmASIOWritable.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::ASIOWritable pure virtual class declaration
//---------------------------------------------------------------------------

#ifndef _DWMASIOWRITABLE_HH_
#define _DWMASIOWRITABLE_HH_

#include <boost/asio.hpp>

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  Interface for classes that wish to be writable via Dwm::ASIO.
  //--------------------------------------------------------------------------
  class ASIOWritable
  {
  public:
    //------------------------------------------------------------------------
    //!  Should write the class to the given socket @c s and return true on
    //!  success, false on failure.
    //------------------------------------------------------------------------
    virtual bool Write(boost::asio::ip::tcp::socket & s) const = 0;
    
    //------------------------------------------------------------------------
    //!  Should return the number of bytes that will be written when the
    //!  Write() member is called.
    //------------------------------------------------------------------------
    virtual uint64_t StreamedLength() const = 0;
  };

}  // namespace Dwm

#endif  // _DWMASIOWRITABLE_HH_
