//===========================================================================
// @(#) $Name$
// @(#) $Id: DwmXmlAttribute.cc 8388 2016-04-17 03:23:45Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2008
//  All rights reserved.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmXmlAttribute.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <string>

#include "DwmXmlAttribute.hh"
#include "DwmSvnTag.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwm/tags/libDwm-0.6.7/src/DwmXmlAttribute.cc 8388 $");

using namespace std;

namespace Dwm {

  namespace Xml {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute()
        : _name(""), _value("")
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute(const Attribute & attribute)
        : _name(attribute._name), _value(attribute._value)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Attribute::Attribute(const std::string & name,
                         const std::string & value)
        : _name(name), _value(value)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Name() const
    {
      return(_name);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Value() const
    {
      return(_value);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & Attribute::Value(const std::string & value)
    {
      _value = value;
      return(_value);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & operator << (std::ostream & os,
                                const Dwm::Xml::Attribute & attribute)
    {
      if (os) {
        os << attribute._name << "=\"" << attribute._value << "\"";
      }
      return(os);
    }
    
  }  // namespace Xml

}  // namespace Dwm

